# Instalación de software libre y propietario

- Máquinas virtuales (M.V.)
  - Concepto de virtualización del hardware y características de los principales productos software libre y propietario, para el uso de máquinas virtuales.
  - Creación y personalización de M.V.
  - Ventajas e inconvenientes de la virtualización.

# Instalación de software libre y propietario

- Consideraciones previas a la instalación de sistemas operativos libres y propietarios.
  - Particionado del disco duro.
  - En sistemas Windows determinar la partición donde instalaremos el S.O.
  - En sistemas Linux determinar las particiones para los distintos puntos de montaje.
  - Controladores (drivers) de almacenamiento necesarios.
- Instalación de sistemas operativos.
  - Requisitos hardware, versiones y licencias.
  - Soporte utilizado para la instalación: CD/DVD, Pendrive, LAN.
  - Datos necesarios para la instalación: usuarios, contraseñas, nombre del equipo, direcciones IP, número de licencia, etc.

----------------

# Obtener información sobre el pocesador en PowerShell

## Información sobre el procesador
```PowerShell
Get-WmiObject Win32_Processor
Get-WmiObject -query "select * from Win32_Processor"
```
## Información sobre la arquitectura
```PowerShell
(Get-WmiObject Win32_Processor).caption
```
## Información sobre la organización
```PowerShell
(Get-WmiObject Win32_Processor).name
```
## Información sobre la realización
```PowerShell
((Get-WmiObject Win32_Processor).name).split("@")[1]
```
## Información sobre los procesadores
```PowerShell
Get-WmiObject -Class Win32_Processor | Select -Property Name, Number*
```
## Número de cores
```PowerShell
Get-WmiObject -Class Win32_Processor | Select-Object NumberOfCores
Get-WmiObject -query "select NumberOfCores from Win32_Processor"
```
## Carga del procesador
```PowerShell
Get-WmiObject win32_processor | Select-Object LoadPercentage
```
## Ejercicios
### Información sobre el procesador
```PowerShell
Get-WmiObject -class "Win32_Processor" | % {
    Write-Host "CPU ID: "
    Write-Host $_.DeviceID
    Write-Host "CPU Model: "
    Write-Host $_.Name
    Write-Host "CPU Cores: "
    Write-Host $_.NumberOfCores
    Write-Host "CPU Max Speed: "
    Write-Host $_.MaxClockSpeed
    Write-Host "CPU Status: "
    Write-Host $_.Status
    Write-Host
}
```
### Procesador es Intel o no?
```PowerShell
if((Get-WmiObject Win32_Processor).name -match "Intel"){"Intel"}else{"No es Intel"}
if((Get-WmiObject Win32_Processor).Caption -match "Intel"){"Intel"}else{"No es Intel"}
```

## Ejemplos vistos en clase
```PowerShell
# Realizar la conexión SSH
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -Computer
# Obtener información sobre el procesador desde Linux mediante una conexión SSH
(Invoke-SSHCommand -Index 0 "bash -c lscpu | grep '32-bit'")
(Invoke-SSHCommand -Index 0 "bash -c lscpu | grep '32-bit' | cut -d':' -f2  | cut -d'-' -f1 ").output
# ¿Es intel?
(Invoke-SSHCommand -Index 0 "lscpu").output
if((Invoke-SSHCommand -Index 0 "lscpu").output -match "Intel"){"Intel"}else{"No es Intel"}
(Invoke-SSHCommand -Index 0 "lscpu").output | select-string "cache"
```

# Parte especial de la clase (conexión con Linux)

## Guardar un fichero html preguntando al usuario qué título quiere
```PowerShell
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html
start chrome .\web.html
```
## Configurar IP en Windows
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

# SSH

## Instalar y ejecutar SSH para PowerShell
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.11 -Credential (Get-Credential)
```

## Ejemplo: obtener información sobre la versión de Linux con WSL
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.14 -Credential (Get-Credential)
Get-SSHSession
Invoke-SSHCommand -Index 0 "uname"
```

# JuiceSSH - SSH Client
https://play.google.com/store/apps/details?id=com.sonelli.juicessh
# JuiceSSH Performance Plugin
https://play.google.com/store/apps/details?id=com.sonelli.juicessh.performancemonitor

# WSL
## Obtener información sobre la versión de Linux con WSL
```PowerShell
wsl uname -r
wsl uname -a
wsl cat /proc/version
```

## Información sobre la arquitectura
```PowerShell
(Invoke-SSHCommand -Index 0 "bash -c ""lscpu | grep 'Architecture'""").output
```

## 3. Gestión del hardware en Linux (nivel intermedio)
https://www.jesusninoc.com/03/03/3-gestion-del-hardware-en-linux-nivel-intermedio/
