# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Ejercicios sobre hilos

## Almacenar información sobre los hilos
```PowerShell
(Get-WmiObject -Class Win32_Thread  | Format-Table -Property priority, thread*, User*Time, kernel*Time ).count | Out-File q:\analisis.txt
Get-Process | select name | Out-File q:\analisis.txt
Start-Sleep -Seconds 5
```

## Mostrar información sobre los hilos del proceso Notepad 
```PowerShell
(Get-WmiObject -Class Win32_Thread -Filter "ProcessHandle = $((gps -name notepad).id)") | %{
    "hilo: "+$_.Handle + " creador hilo: " + $_.ProcessHandle, (Get-Process -Id $_.ProcessHandle).ProcessName
}
```

## Mostrar información sobre los hilos de todos los procesos que se están ejecutando (qué proceso ejecuta el hilo)
```PowerShell
Get-WmiObject Win32_Thread | %{
    $_.Handle,$_.ProcessHandle,(Get-Process -Id $_.ProcessHandle).ProcessName
}
```

## Listar hilos de cada proceso
```PowerShell
Get-WmiObject Win32_Process | %{
    (Get-Process -Id $_.ProcessId),$_.ProcessName,$_.Handle,$_.ProcessId,(Get-Process -Id $_.ProcessId).Threads
}
```

## Almacenar información sobre hilos de forma continuada
```PowerShell
while(1)
{
(Get-WmiObject -Class Win32_Thread  | Format-Table -Property priority, thread*, User*Time, kernel*Time ).count | Out-File q:\analisis.txt -Append
Get-Process | select name | Out-File q:\analisis.txt -Append

Start-Sleep -Seconds 5
"Ejecutado"
}
```

## Mostrar los hilos de cada proceso utilizando WMI y el cmdlet Get-Process
```PowerShell
Get-Process | select name,Threads

(Get-Process -Name notepad) | select Threads | select *

Get-WmiObject -Class Win32_Thread | select Handle,ProcessHandle,priority | sort priority -Descending

(Get-WmiObject -Class Win32_Thread -Filter "ProcessHandle = 1052")

(Get-WmiObject -Class Win32_Thread -Filter "ProcessHandle = $((gps -name notepad).id)") | %{
    $_.Handle, $_.ProcessHandle, (Get-Process -Id $_.ProcessHandle).ProcessName
}
```

## Relación entre servicios y procesos
```PowerShell
Get-WmiObject Win32_Service | %{
    $_.Name,$_.ProcessID,(Get-Process -Id $_.ProcessID).name
}
```

## Ayuda de servicios con procesos
```PowerShell
foreach($elementos in (Get-WmiObject -Class Win32_Service))
{
    $elementos
}

Get-WmiObject -Class Win32_Service | %{
Write-Host $_.Name,$_.ProcessID,(Get-Process -Id $_.ProcessID).name
}
```

## Ayuda de procesos WMI con procesos
```PowerShell
Get-WmiObject Win32_Process | %{
    $_.Handles,$_.ProcessHandle,(Get-Process -Id $_.ProcessHandle).ProcessName
}

Get-WmiObject Win32_Process | %{
    (Get-Process -Id $_.ProcessId),$_.ProcessName,$_.Handle,$_.ProcessId
}
```

## Almacenar el número de procesos e hilos en un fichero junto con la fecha (el script se ejecuta cada cinco segundos)
```PowerShell
while(1)
{
Get-Date | Out-File analisis.txt -Append 
(Get-WmiObject -Class Win32_Thread).count | Out-File analisis.txt -Append 
(Get-Process).count | Out-File analisis.txt -Append
"-------------------------------------------------------" | Out-File analisis.txt -Append
notepad .\analisis.txt
Start-Sleep -Seconds 5
Stop-Process -Name notepad
}
```

# Servicios y relación con procesos
## No funciona porque no puede convertir ProcessID
```PowerShell
Get-WmiObject -Class Win32_Service | Select-Object Name,ProcessID, (Get-Process -Id ProcessID).name
```
## Sí funciona
```PowerShell
Get-WmiObject -Class Win32_Service | %{
Write-Host $_.Name,$_.ProcessID,(Get-Process -Id $_.ProcessID).name
}
```

# Procesos y ruta de ejecución del proceso
```PowerShell
Get-WmiObject -Class win32_process | select Path,ExecutablePath, CommandLine | Format-Custom
```
