# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

--------------------

# Creación y destrucción de procesos
## Creación de procesos (apartado Crear procesos)
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/
## Destrucción de procesos (apartado Matar procesos)
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

# Más información sobre procesos
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

--------------------

# Ejercicio con Base64
## Ejercicio resuelto de CREAR TABLA DE BASE64
https://www.jesusninoc.com/2017/02/11/tabla-de-caracteres-base64/

## EJECUTAR UN START-PROCESS (CREAR UN PROCESO)
```PowerShell
Start-Process -FilePath powershell.exe -ArgumentList '-encodedcommand RwBlAHQALQBQAHIAbwBjAGUAcwBzAA=='
```

## Ejecutar un cmdlet codificado en Base64
https://www.jesusninoc.com/2016/09/24/ejecutar-un-cmdlet-convertido-en-base64/

# Para repasar
- https://github.com/jesnino/PowerShell
- https://github.com/jesnino/PowerShell/tree/master/Repaso
- https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

--------------------

# Ejercicios PowerShell hilos y procesos

```PowerShell
Get-Process | select *
Get-Process | select Threads
Get-Process | select Threads | Format-Custom
(Get-Process | select Threads).count
Get-WmiObject -Class Win32_Thread
Get-WmiObject -Class Win32_Thread  | Format-Table -Property priority, thread*, User*Time, kernel*Time 
(Get-WmiObject -Class Win32_Thread).count
(Get-WmiObject -Class Win32_Thread  | Format-Table -Property priority, thread*, User*Time, kernel*Time).count
```

```PowerShell
Get-WmiObject -Class Win32_Thread
Get-WmiObject -Class Win32_Process
```

```PowerShell
Get-Process | select id,threads
Get-WmiObject win32_process | Select-Object ParentProcessId,ProcessId
```

```PowerShell
Get-Process | select Name,Threads | Out-GridView

(Get-WmiObject -Class Win32_Thread  | Format-Table -Property priority, thread*, User*Time, kernel*Time ).count
(Get-WmiObject -Class Win32_Thread).count

Get-WmiObject -Class Win32_Thread | select id,priority
Get-WmiObject -Class Win32_Process

Get-WmiObject win32_process | Select-Object ParentProcessId,ProcessId

#Process that created the thread
Get-WmiObject -Class Win32_Thread | select handle,ProcessHandle

(Get-WmiObject win32_process) | Select-Object Name,CommandLine | Format-Custom
```

--------------------

# Memoria

## Ejercicios PowerShell sobre variables

### Mostrar un char desde un int
```PowerShell
[Int]'A'[0]
```
### Mostrar un int desde un char
```PowerShell
[Char]65
```
### Ejecutar un cmdlet leyendo desde un fichero el cmdlet
```PowerShell
"gps" | Out-File ejecutar.txt
Invoke-Expression (gc .\ejecutar.txt)
```
### Modificar el contenido de un fichero
```PowerShell
1 | Out-File ejemplo1.txt
(gc ejemplo1.txt)+"modificado" | Out-File ejemplo2.txt
gc .\ejemplo2.txt
```
### Modificar el contenido de un fichero (leer un número de un fichero y sumar un número, después almacenar el varlor)
```PowerShell
1 | Out-File ejemplo1.txt
[Int](gc ejemplo1.txt)+1 | Out-File ejemplo2.txt
gc .\ejemplo2.txt
```
### Modificar el contenido de un fichero (leer un número de un fichero y restar un número, después almacenar el varlor)
```PowerShell
1 | Out-File ejemplo1.txt
[Int](gc ejemplo1.txt)-1 | Out-File ejemplo2.txt
gc .\ejemplo2.txt
``` 
### Modificar el contenido de un fichero utilizando variables (leer un número de un fichero y restar un número, después almacenar el varlor)
```PowerShell
1 | Out-File ejemplo1.txt
$ejemplo1 = [Int](gc ejemplo1.txt)
$ejemplo1 - 1 | Out-File ejemplo2.txt
gc .\ejemplo2.txt
```
### Listar la mitad de un número de procesos y ordenarlos (el usuario introduce los valores en variables y los almacena en ficheros)
```PowerShell
$first = Read-Host "intro first"
$first | Out-File first.txt

$orden = Read-Host "intro orden"
$orden | Out-File orden.txt
gps | select -First ([Int ]$first / 2) | sort $orden
```

### Guardar un valor aleatorio en un fichero
```PowerShell
(Get-Random (1..5)) | Out-File aleatorio.txt
```

## Adjunto ejercicio visto en mi equipo sobre compartir memoria
- Utilizar zonas de memoria compartida en Linux mediante WSL desde PowerShell
https://www.jesusninoc.com/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/
- Uso de las funciones ftok(), shmget(), shmat() y shmctl() (ejemplo)
https://www.jesusninoc.com/11/22/uso-de-las-funciones-ftok-shmget-shmat-y-shmctl-ejemplo/
- Uso de las funciones ftok(), shmget(), shmat() y shmctl()
https://www.jesusninoc.com/2014/11/22/uso-de-las-funciones-ftok-shmget-shmat-y-shmctl/

### Listar los procesos leyendo de una zona de memoria (almacenar un valor que se utiliza para listar un número de procesos)
#### Código para crear la zona de memoria y almacenar el valor, por ejemplo introducir 5
```PowerShell
$codigo = '
#ifndef _SVID_SOURCE
#define _SVID_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <sys/ipc.h>

#endif
typedef struct
{
int num1;
}zona_mem1;
int main (void)
{

//Declaración de variables

key_t clave1; //clave de acceso a la memoria 1
int shmid1; //identificador de la zona de memoria 1
zona_mem1 *pmem1; //Puntero a la 1 zona de memoria
int comprobar; //variable que me indica la posibilidad de error en la llamada a funciones!
char opc; //indicación de continuación de programa o terminación


clave1 = ftok(".",''s'');

//Creación de zona_mem1

shmid1 = shmget(clave1,sizeof(zona_mem1),IPC_CREAT | 0660);

if(shmid1 !=-1)
{
printf("Zona de memoria 1 creada OK! con identificador %d \n", shmid1);
}
else
{
printf("ERROR al crear zona de memoria 1 !! \n");
exit(1);
}

//He obtenido los recursos que necesito, vinculo el proceso con la zona de memoria!!

pmem1 = shmat(shmid1,0,0);

if(pmem1 == -1)
{
printf("Error al vincular el proceso a la zona de memoria 1! \n");
exit(1);
}

pmem1 -> num1 = ' + $(Read-Host "Valor") + ';

//Mantengo en ejecución al programa padre para dar tiempo a leer
do
{
printf("Desea Terminar?? S/N \n");
scanf("%s", &opc);

if(opc == "s")
{

//Elimino las zonas de memoria!!

comprobar = shmctl (shmid1, IPC_RMID,0);

if(comprobar == -1)
{
printf("ERROR al eliminar la 1 zona de memoria!! \n");
exit(1);
}
else
{
printf("Zona de memoria 1 eliminada OK !!\n");
}

}

}while(opc !="s");
}'

$codigo | Out-File escritor.c
wsl cat escritor.c
bash -c "iconv escritor.c -f UTF-16 -t UTF-8 > escritors.c"
wsl gcc escritors.c -o escritor
wsl "./escritor"
```

#### Código para leer la zona de memoria (se listan los procesos, si se ha introducido un 5, se listan 5 procesos)
```PowerShell
$codigo = '
#ifndef SOURCE
#define SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>

#endif

typedef struct
{
int num1;
}zona_mem1;
int main (void)
{

//Declaración de variables

key_t clave1; //clave de acceso a la memoria 1
int shmid1; //identificador de la zona de memoria 1
zona_mem1 *pmem1; //Puntero a la 1 zona de memoria
int comprobar; //variable que me indica la posibilidad de error en la llamada a funciones!
char opc; //indicación de continuación de programa o terminación

//Algoritmo de programa lector.c

clave1 = ftok(".",''s'');

//Creación de zona_mem1

shmid1 = shmget(clave1,sizeof(zona_mem1),0);

if(shmid1 !=-1)
{
printf("Zona de memoria 1 creada OK! con identificador %d \n", shmid1);
}
else
{
printf("ERROR al crear zona de memoria 1 !! \n");
exit(1);
}

//He obtenido los recursos que necesito, vinculo el proceso con la zona de memoria!!

pmem1 = shmat(shmid1,0,0);

if(pmem1 == -1)
{
printf("Error al vincular el proceso a la zona de memoria 1! \n");
exit(1);
}
else
{
printf("%d",pmem1 -> num1);
}
}'

$codigo | Out-File lector.c
wsl cat lector.c
bash -c "iconv lector.c -f UTF-16 -t UTF-8 > lectors.c"
wsl gcc lectors.c -o lector
Get-Process | select -First (wsl "./lector")[1]
```
