 # Módulo profesional 04: Implantación de sistemas operativos (código: 0369)
 ## Contenidos (duración 280 horas) 

- Instalación de software libre y propietario
- Administración de software de base
- Administración y aseguramiento de la información
- Administración de recursos compartidos
- Administración de dominios
- Administración del acceso al dominio
- Supervisión del rendimiento del sistema
- Directivas de seguridad y auditorías
- Resolución de incidencias y asistencia técnica

-------------------

# Libro recomendado para Implantación de sistemas operativos
## Sistemas operativos monopuesto
* https://www.amazon.es/gp/product/8497719719?ie=UTF8&tag=jesusninoc-21&camp=3638&linkCode=xm2&creativeASIN=8497719719

-------------------

# Introducción a ISO
- ¿De qué va la asignatura?
- ¿Cómo voy a evaluar la asignatura?
- Mezcla de tecnologías
- Utilizar Github
https://github.com/jesusninoc/ClasesISO
- WSL (Windows Subsystem for Linux)
https://github.com/jesusninoc/ClasesISO/blob/master/2018-06-01.md
- LOLBin
https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-11.md
- Convertirlo a Bash y PowerShell
https://github.com/dvarrui/libro-de-actividades/blob/master/explicaciones/departamento/files/script-instalar-aula206.rb

# Exámenes ejemplo de tercera evaluación
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-29.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-28.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-23.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-06-06.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-06-03.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-06-04.md

# Trabajo para optar al 10 y a MH
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-31.md

-------------------

# Instalación de software libre y propietario

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.

# WSL
## Windows 10 Installation Guide
https://docs.microsoft.com/en-us/windows/wsl/install-win10
## Check your build number (WSL)
https://docs.microsoft.com/en-us/windows/wsl/troubleshooting#check-your-build-number
## WSL (Windows Subsystem for Linux)
https://github.com/jesusninoc/ClasesISO/blob/cdf3c6ea4c197a5517b0fac5cdf70f381f140842/2018-06-01.md

# Núcleo
## Comandos Kernel
```Bash
uname -r
uname -a
cat /proc/version
dmesg | grep Linux
```

## Comandos versión Windows
```PowerShell
Get-CimInstance Win32_OperatingSystem
[System.Environment]::OSVersion.Version
````

# Cmdlets básicos en PowerShell
## 1. Introducción a PowerShell para administradores de sistemas (nivel básico)
https://www.jesusninoc.com/2016/09/26/1-introduccion-a-powershell-para-administradores-de-sistemas/
## 1. Introducción a PowerShell (nivel intermedio)
https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/

# Ejercicio
## Guardar en un fichero la versión de Windows utilizando un cmdlet
```PowerShell
[System.Environment]::OSVersion.Version | Out-File version.txt
```
## Guardar en un fichero la versión del núcleo de Linux utilizando un cmdlet
```PowerShell
wsl uname -r | Out-File nucleo.txt
```

# R0Ak (The Ring 0 Army Knife) - A Command Line Utility To Read/Write/Execute Ring Zero On For Windows 10 Systems
R0Ak (The Ring 0 Army Knife) - Una utilidad de línea de comandos para leer / escribir / ejecutar Ring Zero On para Windows 10 

r0ak es una utilidad de línea de comandos de Windows que le permite leer, escribir y ejecutar fácilmente código de modo kernel (con algunas limitaciones) desde el símbolo del sistema, sin requerir nada más que privilegios de administrador.
https://www.kitploit.com/2018/09/r0ak-ring-0-army-knife-command-line.html
