# Examen ejemplo de tercera evaluación

## Consideraciones previas
- Lo primero que tienes que tener en cuenta es el rango de IP que vas a utilizar, todos sois distintos, se configura la IP con Windows y Linux.
- Lo que sepas expresar con scripts hazlo, lo que no, lo explicas.
- Utiliza bien las palabras y no te las inventes.
- Piensa en la red que tenemos en el Centro para resolver algunas preguntas.

## Utiliza TODO lo que hemos visto en clase:
- Auditar
- Firewall
- Recuperación MBR
- VPN
- Interfaz de red duplicado
- Conexiones seguras
- Monitorizar
- Gestión de discos
- Netsh
- SSH + SCP
- Carpetas compartidas
- Permisos
- FTP
- GPO
- Mapa de red

## Preguntas:
- Explica cómo puedes saber quién accede a una carpeta compartida en Windows.
```PowerShell
Get-EventLog -LogName security | select Message | select-string "\\localhost\ejemplo"
```
- Explica un procedimiento de copias de seguridad que te parezca lo más óptimo posible, ten en cuenta:
  - Windows o Linux.
    - https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/
    - https://www.jesusninoc.com/03/12/select-files-between-two-dates-and-copy-them/
  - Dejar programada la acción.
    - https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
  - Comprimir y descomprimir
    - https://www.jesusninoc.com/03/15/create-new-compress-archive-file/
    - https://www.jesusninoc.com/02/14/descomprimir-archivos/
  - Cifrar el contenido, método sencillo o complicado.
    - https://www.jesusninoc.com/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
  - También puedes añadir otros elementos relacionados con la copia de seguridad como la reparación
  - Funciones simples y complejas
```PowerShell
##########################
# Funciones simples
##########################
function crearestructura()
{
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force

    $fecha = (Get-Date).ToString("yyyyMMdd")
    cd copia
    mkdir ($fecha) -force
}

crearestructura

function copiararchivos()
{
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha -force
    }
}

copiararchivos

function recuperar
{
  param($fichero)
  begin
  {
  }
  process
  {
    Expand-Archive -LiteralPath $fichero -DestinationPath desco\
  }
  end
  {
  }
}

recuperar .\comprimido.zip

##############################################################################

##########################
# Función compleja
##########################
function copiaseguridad
{
  param()
  begin
  {
    "archivo1" > archivo1.txt
    "archivo2" > archivo2.txt
    mkdir copia -force
    $fecha = (Get-Date).ToString("yyyyMMdd")
    mkdir copia\$fecha -force
  }
  process
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls *.txt | %{
        cp $_ copia\$fecha\ -force
    }
  }
  end
  {
    $fecha = (Get-Date).ToString("yyyyMMdd")
    ls copia\$fecha
    Compress-Archive -LiteralPath copia\$fecha –CompressionLevel Optimal -DestinationPath comprimido.zip -Force
  }
}
copiaseguridad
```
- Se ha producido una infección en un sistema operativo Windows,
  - ¿qué elementos comprobarías para detectar dicha infección?
      - https://www.jesusninoc.com/07/11/analisis-de-procesos-y-conexiones-de-red-con-powershell/
  - ¿cómo impides que se produzcan infecciones el sistema operativo?
  - ¿Windows dispone de herramientas centralizadas para evitarlo?

```PowerShell
function monitorizar
{
  param()
  begin
  {
  }
  process
  {
    foreach($conex in @(netstat -ano))
    {
        foreach($proceso in ps | where id -EQ ((Get-Process -name chrome | sort cpu -Descending | select -First 2)[0].id))
        {
            if($conex -match $proceso.Id -and $proceso.Id -ne 4 -and $proceso.Id -ne 0)
            {
                write-host $conex “-PROCESO->” $proceso.Name $proceso.Id
            }
        }
    }
  }
  end
  {
  }
}

monitorizar
```
  
- Explica todo el proceso para realizar una clonación.
- Explica todo lo que sepas sobre permisos en Windows.
- ¿Cómo puedes hacer una sincronización en Linux?, ¿puedes hacerla entre equipos?, ¿cómo?
- ¿Un driver falla, qué haces para arrancar el sistema?
- ¿Un componente gráfico, qué haces para arrancar el sistema?
- Se puede lograr utilizar carpetas compartidas de Windows en Linux y que se queden arrancadas desde que se carga Linux.
- Prepara un script para guardar los logs que sean problemáticos todos los días de la semana, se tienen que enviar a una carpeta compartida o utilizando un protocolo seguro (entorno lo más seguro que puedas), hay que colocarlos de forma ordenada.
    - https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
- Explica para qué sirven las auditoría y qué relación tiene con los permisos.
- ¿Qué hace el siguiente script? (explica en detalle el código)
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```
