# Examen liberatorio 2019 FINAL ISO

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Imprescindible
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## Caso web periódico

### Eres el nuevo administrador de sistemas del diario el Universo. El diario funciona así: los periodistas sus ficheros HTML a sus carpetas en la red mediante un interfaz web (una Intranet). Cada periodista ve sus propios ficheros y no ve los de sus compañeros. Por ejemplo: Juan crea la página 1 del periódico y sube dicha página al servidor web.

## Resuelve lo siguiente:
1) Junta todas las páginas del periódico de todos los periodistas.
```PowerShell
mkdir usuario1; cd usuario1
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina1.html
cd ..
mkdir usuario2; cd usuario2
"htmlkljsdafflkjsadfljsdaf" | Out-File pagina2.html
cd ..

ls *.html -recurse | %{
    $periodidcocomp = $periodidcocomp + (gc $_)
}

$periodidcocomp | out-file periodicocompleto.html
```
2) Haz copias de seguridad para diferentes momentos del día y al final del día haz copia de todo el periódico completo.
```PowerShell
(Get-Date).ToString("yyyyMMddhh")

$fecha = (Get-Date).ToString("yyyyMMddhh")
mkdir ($fecha) -force
cd $fecha

ls *.html -recurse | %{
    copy $_ $fecha
}
```
3) Incidencia. Alguien ha mandado imprimir el periódico entero. Tienes que pararlo porque no es el momento de imprimirlo.
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
#$perio = gc .\periodicocompleto.html
$b=[Text.Encoding]::ASCII.GetBytes("gc perio.html | out-printer")
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
##Server
while(1)
{
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
if([Text.Encoding]::ASCII.GetString($content) | select-string "print")
{
    "ha mandado imprimir"
}
}
```
4) Opcional. El periódico automático. Crear cada página HTML utilizando una base de datos
* https://www.jesusninoc.com/09/20/crear-un-fichero-html-con-el-contenido-de-la-tabla-posts-de-wordpress-con-powershell/
