# Ayuda examen final Linux

## Linux-Commands Cheat Sheet
http://lzone.de/cheat-sheet/Linux-Commands

## Funciones de un sistema operativo.
### Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
```Bash
/sys/
```
```Bash
/proc/
```
```Bash
/dev/
```
```Bash
modprobe
```
```Bash
lsmod
```
```Bash
lspci
```
```Bash
lsusb
```
```Bash
/dev/sd*
```

### Administrar la ejecución de los procesos. Planificación.
```Bash
ps, top, free
```
```Bash
syslog, dmesg
```
```Bash
/etc/, /var/log/
```
```Bash
/boot/, /proc/, /dev/, /sys/
```
```Bash
&
```
```Bash
bg
```
```Bash
fg
```
```Bash
jobs
```
```Bash
kill
```
```Bash
nohup
```
```Bash
ps
```
```Bash
top
```
```Bash
free
```
```Bash
uptime
```
```Bash
pgrep
```
```Bash
pkill
```
```Bash
killall
```
```Bash
screen
```

### Controlar el acceso de los programas o los usuarios a los recursos del sistema.
```Bash
iostat
```
```Bash
netstat
```
```Bash
w
```
```Bash
top
```
```Bash
sar
```
```Bash
vmstat
```
```Bash
pstree, ps
```
```Bash
isof
```
```Bash
uptime
```
```Bash
swap
```

## Consideraciones previas a la instalación de sistemas operativos libres y propietarios.
```Bash
fdisk
```
```Bash
gdisk
```
```Bash
parted
```
```Bash
mkfs
```
```Bash
mkswap
```

### Particionado del disco duro (Linux).
```Bash
df -h
```
```Bash
sudo fdisk -l
```
```Bash
sudo blkid
```
```Bash
sudo mkdir mount_name
```
```Bash
sudo mount -t auto -v /dev/sdb1 /mnt/mount_name
```

## Instalación/desinstalación de aplicaciones. Requisitos hardware y software, versiones y licencias.
### Deb
```Bash
/etc/apt/sources.list
```
```Bash
dpkg
```
```Bash
dpkg-reconfigure
```
```Bash
apt-get
```
```Bash
apt-cache
```
```Bash
aptitude
```

### Rpm
```Bash
rpm
```
```Bash
rpm2cpio
```
```Bash
/etc/yum.conf
```
```Bash
/etc/yum.repos.d/
```
```Bash
yum
```
```Bash
yumdownloader
```

## Actualización de sistemas operativos y aplicaciones.
```Bash
apt
```

## Registros (logs) del sistema.
```Bash
/var
```

### Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
### Herramientas para su monitorización en sistemas libres y propietarios.
### Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.
```Bash
cat
```
```Bash
cut
```
```Bash
expand
```
```Bash
fmt
```
```Bash
head
```
```Bash
join
```
```Bash
less
```
```Bash
nl
```
```Bash
od
```
```Bash
paste
```
```Bash
pr
```
```Bash
sed
```
```Bash
sort
```
```Bash
split
```
```Bash
tail
```
```Bash
tr
```
```Bash
unexpand
```
```Bash
uniq
```
```Bash
wc
```

## Administración de usuarios y grupos locales.
```Bash
/etc/passwd, /etc/group
```
```Bash
id, who, w
```
```Bash
sudo, su
```
```Bash
/etc/passwd, /etc/shadow, /etc/group, /etc/skel/
```
```Bash
id, last
```
```Bash
useradd, groupadd
```
```Bash
passwd
```
```Bash
/etc/passwd
```
```Bash
/etc/shadow
```
```Bash
/etc/group
```
```Bash
/etc/skel/
```
```Bash
chage
```
```Bash
getent
```
```Bash
groupadd
```
```Bash
groupdel
```
```Bash
groupmod
```
```Bash
passwd
```
```Bash
useradd
```
```Bash
userdel
```
```Bash
usermod
```

### Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
### Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular.
### Usuarios y grupos predeterminados.
```Bash
/etc/passwd
```
```Bash
/etc/shadow
```
```Bash
/etc/group
```

### Seguridad de cuentas de usuario.
### Seguridad de las contraseñas:
#### Algoritmos para la elección de contraseñas seguras.

## Configuración del protocolo TCP/IP en un cliente de red.
```Bash
route, ip route show
```
```Bash
ifconfig, ip addr show
```
```Bash
netstat, ip route show
```
```Bash
/etc/resolv.conf, /etc/hosts
```
```Bash
ping
```
```Bash
host
```
```Bash
ip link
```
```Bash
ip address
```
```Bash
ip addrlabel
```
```Bash
ip neighbour
```
```Bash
ip route
```
```Bash
ip rule
```
```Bash
ip maddress
```
```Bash
ip mroute
```
```Bash
ip tunnel
```
```Bash
ip xfrm state
```
```Bash
ifconfig
```
```Bash
netstat
```
```Bash
netstat -n
```
```Bash
netstat -anp
```
```Bash
netstat -p
```
```Bash
netstat -a
```
## Configuración de la resolución de nombres.
```Bash
/etc/hosts
```
```Bash
/etc/resolv.conf
```
```Bash
/etc/nsswitch.conf
```
```Bash
host
```
```Bash
dig
```
```Bash
getent
```

## Ficheros de configuración de red.
```Bash
/etc/resolv.conf, /etc/hosts
```

## Gestión de sistemas de archivos mediante comandos y entornos gráficos.
### Crear o modificar un archivo
```Bash
vi nombre
```
### Crear un directorio
```Bash
mkdir
```
### Ver el contenido de un archivo
```Bash
cat
```
### Acceder al contenido de un directorio
```Bash
cd
```
### Listar el contenido de un directorio
```Bash
ls
```
### Ver la estructura de un directorio
```Bash
tree
```
### Eliminar un archivo
```Bash
rm
```
### Eliminar un directorio
```Bash
rmdir
```
### Copiar un archivo o un directorio
```Bash
copy
```
### Mover un archivo o un directorio
```Bash
mv
```
### Renombrar un archivo o un directorio
```Bash
mv
```
### Establecer permisos en un archivo o un directorio
```Bash
chmod
```
### Comprimir y descomprimir un archivo o un directorio
```Bash
gzip
```
### Imprimir un archivo
```Bash
lpr
```

## Gestión de la información del sistema. Rendimiento. Estadísticas
```Bash
iostat
```
```Bash
netstat
```
```Bash
w
```
```Bash
top
```
```Bash
sar
```
```Bash
vmstat
```
```Bash
pstree, ps
```
```Bash
isof
```
```Bash
uptime
```
```Bash
swap
```

## Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
```Bash
df -h
sudo fdisk -l
sudo blkid
sudo mkdir mount_name
sudo mount -t auto -v /dev/sdb1 /mnt/mount_name
```

## Permisos locales de acceso a ficheros y directorios.
```Bash
chmod
```
```Bash
umask
```
```Bash
chown
```
```Bash
chgrp
```
```Bash
ls -l, ls -a
```
```Bash
chmod, chown
```

## Tipos de copias de seguridad:
### Locales y Remotas.
## Planes de copias de seguridad y restablecimiento.
## Compresión de datos.
```Bash
dd
```
```Bash
tar
```
```Bash
mt
```
```Bash
rsync
```

## Permisos de red. Permisos locales. Herencia. Permisos efectivos.
```Bash
chmod
```
```Bash
umask
```
```Bash
chown
```
```Bash
chgrp
```

## Herramientas de monitorización en tiempo real.
## Herramientas de monitorización continuada.
## Herramientas de análisis del rendimiento.
## Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
## Registros de sucesos.
```Bash
/var
```
```Bash
iostat
```
```Bash
netstat
```
```Bash
w
```
```Bash
top
```
```Bash
sar
```
```Bash
vmstat
```
```Bash
pstree, ps
```
```Bash
isof
```
```Bash
uptime
```
```Bash
swap
```

## Monitorización de sucesos.
## Gestión de aplicaciones, procesos y subprocesos.
## Monitorización de aplicaciones y procesos.
## Tareas
```Bash
/etc/cron.{d,daily,hourly,monthly,weekly}/
```
```Bash
/etc/at.deny
```
```Bash
/etc/at.allow
```
```Bash
/etc/crontab
```
```Bash
/etc/cron.allow
```
```Bash
/etc/cron.deny
```
```Bash
/var/spool/cron/
```
```Bash
crontab
```
```Bash
at
```
```Bash
atq
```
```Bash
atrm
```
```Bash
anacron
```
```Bash
/etc/anacrontab
```
