# Resolver situaciones 2019 (examen liberatorio)

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Imprescindible
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## Caso web

### Crear el escenario
- Crear carpetas para cada uno de los usuarios de un Directorio Activo que se van a utilizar como carpeta de usuario para el servidor web
```PowerShell
function crear($direccion)
{
    cd $direccion
    mkdir (Get-LocalUser | select name).name
}

crear C:\xampp\htdocs\usuarios
```

### Copia de seguridad
- Los usuarios suben información a una página web
```PowerShell
#Crear un formulario, añadir una etiqueta, un botón y una caja de texto
#Formulario
$Form = New-Object System.Windows.Forms.Form
$Form.Text="Formulario"
$Form.Size=New-Object System.Drawing.Size(500,500)
$Form.StartPosition="CenterScreen"

#Etiqueta
$Label=New-Object System.Windows.Forms.Label
$Label.Text="Etiqueta de ejemplo"
$Label.AutoSize=$True
$Label.Location=New-Object System.Drawing.Size(180,160)

#Botón
$Button=New-Object System.Windows.Forms.Button
$Button.Size=New-Object System.Drawing.Size(75,23)
$Button.Text="Botón"
$Button.Location=New-Object System.Drawing.Size(195,180)

#Caja de texto
$TextBox = New-Object System.Windows.Forms.TextBox
$TextBox.Location = New-Object System.Drawing.Size(110,215)
$TextBox.Size = New-Object System.Drawing.Size(260,20)

#Caja de texto 2
$TextBox2 = New-Object System.Windows.Forms.TextBox
$TextBox2.Location = New-Object System.Drawing.Size(110,255)
$TextBox2.Size = New-Object System.Drawing.Size(260,20)
$TextBox2.Text

#Añadir etiqueta
$Form.Controls.Add($Label)


#Añadir caja de texto
$Form.Controls.Add($TextBox)

$Form.Controls.Add($TextBox2)

$Button.add_Click{
 cp $TextBox.Text $TextBox2.Text
 $form.Close()
}

#Añadir botón
$Form.Controls.Add($Button)

$Form.ShowDialog()
```
- La información que se sube a la página web debe ser copiada a cinco carpetas (inmediatamente)
- Se tienen que realizar copias de seguridad comprimidas de los datos que suben los usuarios

### Monitorización a nivel de red
- Un usuario que no debe, ha subido un fichero que se llama imagen2.jpg, se trata de un .exe
- Controlar que se ha subido dicho fichero y copiarlo en una carpeta temporal para analizarlo posteriormente
- ¿Se puede detectar a nivel DNS?
- ¿Se puede controlar la auditoría?

### Incidencia
- El fichero imagen2.jpg ha infectado un equipo de la red, simular la infección y detectarlo
- Solucionar el problema de la infección (simular la infección) y recuperar la unidad cifrada del usuario recuperando una copia de seguridad (de los archivos del usuario)

### Opcional
- Crear páginas web leyendo de una base de datos
