# Resolver situaciones (examen liberatorio)

## Tener en cuenta
- Controlar y gestionar el uso del hardware del ordenador.
- Administrar la ejecución de los procesos.
- Controlar el acceso de los programas o los usuarios a los recursos del sistema.
- Particionado del disco duro.
- Registros (logs) del sistema.
- Configuración del protocolo TCP/IP en un cliente de red.
- Configuración de la resolución de nombres.
- Ficheros de configuración de red.
- Gestión de sistemas de archivos.
- Permisos locales de acceso a ficheros y directorios.
- Planes de copias de seguridad y restablecimiento.
- Compresión de datos.
- Permisos de red. Permisos locales.
- Registros de sucesos.
- Monitorización de sucesos.

## Situaciones

## 1. Recorrer los equipos de la red (mediante IP o Directorio Activo) y detectar si se ha conectado un móvil, si se ha conectado, copiar un fichero que se encuentra en una carpeta compartida (Samba) al móvil. Copiar y comprimir los archivos de tipo JPG que se encuentren en el móvil en una carpeta compartida en Windows.

```PowerShell
foreach($tercero in 1..123)
{
# $equipo = "localhost"
$equipo = "192.168.104."+$tercero
$resultados = Invoke-Command -ComputerName $equipo -ScriptBlock {Get-PnpDevice | Where-Object { $_.class -EQ 'PrintQueue' } | Select-Object FriendlyName}
if($resultados.count -gt 2)
{
    if(Invoke-Command -ComputerName $equipo -ScriptBlock {Get-PSDrive | select root | Where-Object {$_.Root -match "e:"}})
    {
        "Copiar en la unidad del móvil un fichero.apk"
        "Copiar los ficheros jpg en una carpeta compartida en Windows"
        Invoke-Command -ComputerName $equipo -ScriptBlock {ls -Filter .jpg2 | Compress-Archive}
    }
}
}
```

### Ver los teléfonos móviles que se han conectado al sistema operativo
https://www.jesusninoc.com/2016/12/01/ver-los-telefonos-moviles-que-se-han-conectado-al-sistema-operativo/

### Montar carpeta de Windows en Linux
```Bash
sudo mount -t cifs //192.168.0.100/CARPETA\ COMPARTIDA -o username=usuario,password=contrasena /mnt/compartida
```

## 1.1. Añadir la posibilidad de realizar capturas de pantalla y guardarlas en formato JPG, eso sería lo que se comprime.

### Realizar una captura de pantalla y almacenarla en formato JPG
```PowerShell
function captura()
{
    $Path='captura.jpg2’
    $Path
    $Bitmap=New-Object System.Drawing.Bitmap([System.Windows.Forms.Screen]::PrimaryScreen.Bounds.Width, [System.Windows.Forms.Screen]::PrimaryScreen.Bounds.Height)
    $Graphics=[System.Drawing.Graphics]::FromImage($Bitmap)
    $Graphics.CopyFromScreen((New-Object System.Drawing.Point(0,0)), (New-Object System.Drawing.Point(0,0)), $Bitmap.Size)
    $Graphics.Dispose()
    $Bitmap.Save($Path,'Bmp')
    $Bitmap.Dispose()
}
captura
```

## 2. Detectar y detener una fuga de información analizando peticiones por la red, extraer la mayor cantidad de información (nombre usuario, equipos, etc.)

## 2.1. Detectar que se ha transmitido por la red un fichero comprimido con un fichero JPG dentro y crear un log con información sobre lo que ha ocurrido.

## 2.2. Detectar y detener una aplicación que realiza capturas de pantalla y mueve a una carpeta compartida.

### Mediante tshark detectar la utilización del puerto 445 y 139 (SMB, Server Message Block)
```PowerShell
tshark -p -w FILENAME -f "port 445"
```

### Tcpdump Examples
https://hackertarget.com/tcpdump-examples/

### Malicious Powershell Targeting UK Bank Customers
https://isc.sans.edu/forums/diary/Malicious+Powershell+Targeting+UK+Bank+Customers/23675/

### Solución de @ArticSeths utilizando eventos para detectar que las capturas se mueven a una carpeta compartida

```PowerShell
function Create-Event([string]$disk){
    [string]$diska = $disk+":/"
    echo $disk
    $fsw = New-Object IO.FileSystemWatcher $diska, '*.*' -Property @{IncludeSubdirectories = $true;NotifyFilter = [IO.NotifyFilters]'FileName, LastWrite'} 
    Register-ObjectEvent $fsw Created -SourceIdentifier FileCreated$disk -Action {
        $name = $Event.SourceEventArgs.Name 
        $changeType = $Event.SourceEventArgs.ChangeType 
        $timeStamp = $Event.TimeGenerated
    
        Write-Host "Se ha creado un archivo zip '$name' a $timeStamp" -fore green
        [Reflection.Assembly]::LoadWithPartialName('System.IO.Compression.FileSystem')
        [IO.Compression.ZipFile]::OpenRead('E:/'+$name).Entries.FullName | % {
            Write-Host $_ -fore green
            if($_ -like "*.jpg"){
                Write-Host "tiene imagen" -fore green
               Out-File -FilePath C:\Users\Admin\documentos\logZIP.txt -Append -InputObject "The file '$name' was $changeType at $timeStamp"

               [Reflection.Assembly]::LoadWithPartialName("System.Drawing")
                function screenshot([Drawing.Rectangle]$bounds, $path) {
                   $bmp = New-Object Drawing.Bitmap $bounds.width, $bounds.height
                   $graphics = [Drawing.Graphics]::FromImage($bmp)

                   $graphics.CopyFromScreen($bounds.Location, [Drawing.Point]::Empty, $bounds.size)

                   $bmp.Save($path)

                   $graphics.Dispose()
                   $bmp.Dispose()
                }

                $bounds = [Drawing.Rectangle]::FromLTRB(0, 0, 1000, 900)
                screenshot $bounds "C:\Users\Admin\documentos\screenshot.png"
                Write-Host "captura" -fore green
            }
        }
    }
}
while($true){
    
    (Get-Partition).DriveLetter | % {
        $letter = $_
        if($letter -notlike 'C' -or $letter -notlike 'D'){
            echo $letter
            if(Get-EventSubscriber | where SourceIdentifier -ne $letter){
                Create-Event -disk $letter
            }
        }        
    }
}
```
