# Resolución de incidencias y asistencia técnica:
- Interpretación, análisis y elaboración de documentación técnica.
- Interpretación, análisis y elaboración de manuales de instalación y configuración de sistemas operativos y aplicaciones.
- Licencias de cliente y licencias de servidor.
- Control de versiones y licencias.
- Instalaciones desatendidas.
- Implementación de ficheros de respuestas.
- Servidores de actualizaciones automáticas.
- Asistencia remota.
- Partes de incidencias.
- Protocolos de actuación.
- Administración remota.

# Monitorizar

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

## System Monitor
System Monitor (Sysmon) is a Windows system service and device driver that, once installed on a system, remains resident across system reboots to monitor and log system activity to the Windows event log. It provides detailed information about process creations, network connections, and changes to file creation time. By collecting the events it generates using Windows Event Collection or SIEM agents and subsequently analyzing them, you can identify malicious or anomalous activity and understand how intruders and malware operate on your network.
* https://www.fwhibbit.es/sysmon-el-gran-hermano-de-windows-y-el-super-sysmonview

Install with default settings (process images hashed with sha1 and no network monitoring)
```MD-DOS
sysmon -accepteula –i
```
Install with md5 and sha256 hashing of process created and monitoring network connections
```MD-DOS
sysmon -accepteula –i –h md5,sha256 –n
```
Install Sysmon with a configuration file (as described below)
```MD-DOS
sysmon –accepteula –i c:\windows\config.xml
```
Uninstall
```MD-DOS
sysmon –u
```
Dump the current configuration
```MD-DOS
sysmon –c
```
Change the configuration to use all hashes, no network monitoring and monitoring of DLLs in Lsass
```MD-DOS
sysmon –c –h * –l lsass.exe
```
Change the configuration of sysmon with a configuration file (as described below)
```MD-DOS
sysmon –c c:\windows\config.xml
```
Change the configuration to default settings
```MD-DOS
sysmon –c --
```
Show the configuration schema
```MD-DOS
sysmon -s
```

## Sources, configuration and how to detect evil things utilizing Microsoft Sysmon
https://github.com/MHaggis/sysmon-dfir

# Logs en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

## List event log
https://www.jesusninoc.com/2018/03/27/list-event-log

## Write-EventLog
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/write-eventlog?view=powershell-5.1

## Escribir y ver un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/

## Almacenar información convertida a byte en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/05/almacenar-informacion-convertida-a-byte-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

## Ejecutar la información que se encuentra en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/06/ejecutar-la-informacion-que-se-encuentra-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

## Windows Event Log to the Dark Side — Storing Payloads and Configurations
https://medium.com/@5yx/windows-event-log-to-the-dark-side-storing-payloads-and-configurations-9c8ad92637f2

## Active Directory: Configuring Event Log Subscriptions (Forwarding)
https://sid-500.com/2018/04/23/active-directory-configuring-event-log-subscriptions-forwarding/

## HOW TO DETECT PASS-THE-HASH ATTACKS
https://blog.stealthbits.com/how-to-detect-pass-the-hash-attacks/

# Logs en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-13.md#registros-de-sucesos

```Bash
cd /var/log
ls
```

- /var/log/message: registro de mensajes generales del sistema
- /var/log/auth.log: log de autenticación
- /var/log/kern.log: registro del kernel
- /var/log/cron.log: registro de crond
- /var/log/maillog: registro del servidor de mails
- /var/log/qmail/ : registro de Qmail
- /var/log/httpd/: registro de errores y accesos a Apache
- /var/log/lighttpd: registro de errores y accesos a Lighttpd
- /var/log/boot.log : registro de inicio del sistema
- /var/log/mysqld.log: registro de la base de datos MySQL
- /var/log/secure: log de autenticación
- /var/log/utmp or /var/log/wtmp : registro de logins

## Analizar logs en Linux
### Regular Expressions
```Bash
 grep -a "user juanito" /var/log/auth.log
```
### Tail
```Bash
$ tail -f /var/log/auth.log | grep -a 'invalid'
```
### Cut
```Bash
grep "authentication failure" /var/log/auth.log | cut -d '=' -f 8
```
### Awk
```Bash
awk '/sshd.*invalid user/ { print $9 }' /var/log/auth.log
```

-------------------------------

# Casos
## Detectar un problema de red
## Detectar en los logs que hay intentos de obtener el fichero passwd
* https://www.jesusninoc.com/05/08/consulta-para-ver-intentos-de-obtener-el-fichero-passwd/
### Solución con una query
```PowerShell
.\LogParser.exe "SELECT * FROM 'C:\xampp\apache\logs\access.log' where text like '%passwd%'"
```
