# Supervisión del rendimiento del sistema
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Monitorización

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

## Monitorizar procesos
### Arranque y procesos del sistema Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-01-23.md

## Monitorizar red
### Enabling DNS Logging for Windows Server 2012
http://support.moonpoint.com/network/dns/windows/logging/srvr2012.php

### Mostrar información sobre las reglas del Firewall de Windows con PowerShell
```PowerShell
$f = New-object -comObject HNetCfg.FwPolicy2
$f.Rules | Select-Object name,applicationname,localports,remoteports | Out-GridView
```

### Display list of blocked ports
```PowerShell
$f = New-object -comObject HNetCfg.FwPolicy2
$f.rules |  where {$_.action -eq "0"} | select name,applicationname,localports
```

## DLL
* Run PowerShell with rundll32. Bypass software restrictions https://github.com/p3nt4/PowerShdll
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-13.md
* https://www.jesusninoc.com/2018/04/15/ejecutar-microsoft-coff-binary-file-dumper-dumpbin-exe-desde-powershell/

### Integridad
#### Comprobar si ha cambiado algún fichero utilizando la función hash SHA1
https://www.jesusninoc.com/2016/01/27/comprobar-si-ha-cambiado-algun-fichero-utilizando-la-funcion-hash-sha1/

### Ejercicio
#### Detectar que ha cambiado una dll analizando el DNS
```PowerShell
# Buscar resolución en DNS
"jesusninoc.com/wmi.dll" > captura.log

gc .\captura.log | %{
        if ($_ -match "dll")
        {
            $_.split("/")[1]
        }
    }


#### Localizar la posición de la dll en un listado de dll's
(gc .\posciones.txt)[(gc .\posciones.txt).IndexOf("luis")]
```

## WMIC

### Listar actualizaciones y almacenar en un fichero html
```MS-DOS
wmic qfe list full /format:htable > hotfixes.htm
```

### Examples of WMIC commands for Windows .NET SERVER Family 
https://www.cs.cmu.edu/~tgp/scsadmins/winadmin/WMIC_Queries.txt

### Enable RDP remotely via #wmic on #Windows 2008 and above: 
```MS-DOS
wmic /namespace:\\root\CIMV2\TerminalServices PATH Win32_TerminalServiceSetting WHERE (__CLASS !="") CALL SetAllowTSConnections 1
```

### WMIC.EXE Whitelisting Bypass - Hacking with Style, Stylesheets
https://subt0x11.blogspot.com.es/2018/04/wmicexe-whitelisting-bypass-hacking.html

### Living Off The Land Binaries And Scripts - (LOLBins and LOLScripts)
https://github.com/api0cradle/LOLBAS

### GTFOBins
GTFOBins is a curated list of Unix binaries that can be exploited by an attacker to bypass local security restrictions.
https://gtfobins.github.io/

## Analizar datos en memoria

### Leer el contenido de un fichero en ASCII y representarlo en decimal
http://www.jesusninoc.com/2017/01/29/leer-el-contenido-de-un-fichero-en-ascii-y-representarlo-en-decimal/

### Crear un fichero de volcado de memoria de un proceso
http://www.jesusninoc.com/2016/03/04/crear-un-fichero-de-volcado-de-memoria-de-un-proceso/

### Buscar una cadena dentro de un fichero de volcado de memoria
http://www.jesusninoc.com/2016/03/13/buscar-una-cadena-dentro-de-un-fichero-de-volcado-de-memoria/


# Copias de seguridad
## En Windows
### 10. Gestión del rendimiento en PowerShell para administradores de sistemas
https://www.jesusninoc.com/2016/11/16/10-gestion-del-rendimiento-en-powershell-para-administradores-de-sistemas/
### Simulación de copia diferencial e incremental
https://github.com/jesusninoc/PowerShell/tree/master/CopiasSeguridad
### Comprimir archivo
https://www.jesusninoc.com/2015/02/12/comprimir-archivo/

## En Linux
https://www.ochobitshacenunbyte.com/2017/07/10/copias-de-seguridad-con-dump-y-restore-en-linux/

## Zip bomb
https://en.wikipedia.org/wiki/Zip_bomb

# Almacenamiento en Bases de datos

## Introduction to SQL
https://www.w3schools.com/sql/sql_intro.asp

## Ejercicios curso MySQL con PowerShell
https://www.jesusninoc.com/2017/02/20/ejercicios-curso-mysql-con-powershell/

## Análisis de una petición a MySQL con SoftPerfect Network Protocol Analyzer
https://www.jesusninoc.com/2017/03/31/analisis-de-una-peticion-a-mysql-con-softperfect-network-protocol-analyzer/

## Enumerar instancias de SQL Server (ADO.NET)
SQL Server permite que las aplicaciones busquen instancias de SQL Server en la red actual. La clase SqlDataSourceEnumerator expone esta información para el programador de la aplicación, suministrando una DataTable que contiene información acerca de todos los servidores visibles.
https://docs.microsoft.com/es-es/dotnet/framework/data/adonet/sql/enumerating-instances-of-sql-server

# Operaciones en red
## Recorrer un rango de direcciones IP
https://www.jesusninoc.com/2017/07/14/recorrer-un-rango-de-direcciones-ip/

## Recorrer un rango de direcciones IP y comprobar si un puerto está abierto
https://www.jesusninoc.com/2016/06/12/recorrer-un-rango-de-direcciones-ip-y-comprobar-si-un-puerto-esta-abierto/

## Obtener información sobre los dispositivos USB conectados en un equipo del dominio con PowerShell
https://www.jesusninoc.com/2017/07/23/obtener-informacion-sobre-los-dispositivos-usb-conectados-en-un-equipo-del-dominio-con-powershell/

# SSH
## How To Copy Files With Rsync Over SSH
https://www.digitalocean.com/community/tutorials/how-to-copy-files-with-rsync-over-ssh
