# Supervisión del rendimiento del sistema
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Monitorización

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

## Introducción
### Encontrarse a uno mismo
```PowerShell
Get-EventLog Security | Where-Object Message -Match "asir1joselui"
```

### Registrar un evento cuando se logre realizar una conexión entre un cliente y un servidor mediante UDP (almacenar la dirección IP de la conexión del cliente o del servidor)
#### Server and client (Sockets UDP)
https://www.jesusninoc.com/12/29/server-and-client/
#### Escribir y ver un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/
#### Verificar en el registro de eventos que se ha realizado una conexión
```PowerShell
Get-EventLog Application | Where-Object Message -Match "192.168"
```
#### Solución (casi)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]"192.168.43.61",$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" -EventID 916 -EntryType Information -Message "192.168.43.108" -Category 2 -RawData 10,20')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
Invoke-Expression ([Text.Encoding]::ASCII.GetString($content))
```
#### Solución (final)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]"192.168.43.61",$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('hola')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" -EventID 916 -EntryType Information -Message "$endpoint | select adress" -Category 2 -RawData 10,20
```

### Display the top ten running processes - sorted by memory usage
https://www.commandlinefu.com/commands/view/15786/display-the-top-ten-running-processes-sorted-by-memory-usage

### easily strace all your apache processes
https://www.commandlinefu.com/commands/view/17621/easily-strace-all-your-apache-processes

### Bg, Fg, &, Ctrl-Z – 5 Examples to Manage Unix Background Jobs
https://www.thegeekstuff.com/2010/05/unix-background-job

### Analizar conexiones UDP y relacionarlas con los procesos
```PowerShell
Get-NetUDPEndpoint | Select-Object LocalAddress,LocalPort,OwningProcess,@{n='Nombre proceso';e={Get-Process -id ($_ | Select-Object -ExpandProperty OwningProcess) | Select-Object -ExpandProperty Name}}
Get-NetUDPEndpoint | Select LocalAddress,LocalPort,OwningProcess,@{n='NombreP';e={(Get-Process -id $_.OwningProcess | Select Name).name}}
```

### Analizar servicios con PowerShell
https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/

### The Win32_StartupCommand WMI class represents a command that runs automatically when a user logs onto the computer system
```PowerShell
Get-CimInstance -ClassName Win32_StartupCommand
```

### Ejercicios introducción monitorizar
```PowerShell
# (INCORRECTO) Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
Get-CimInstance -ClassName Win32_StartupCommand  | select Caption, @{n='NombreP';e={(Get-Process -name $_.Caption | Select Name).name}}

# Comprobar que se está ejecutando un programa que se arranca al inicio del arranque del sistema operativo
Get-Process -Name MSOSYNC

# (CORRECTO 1) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

Get-Process -Name $acumul

# (CORRECTO 2) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
function comprobar($programa){
    Get-Process -Name $programa -ErrorAction Ignore
}

Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        comprobar $temperal[$temperal.Count-1]

}

# (CORRECTO 3) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

$acumul | %{
    $_
    ((Get-Process).name.toupper()).contains($_.toupper())
}
```

## Monitorizar procesos
### 7. Gestión de procesos en PowerShell
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/
### Process Monitor
https://docs.microsoft.com/en-us/sysinternals/downloads/procmon
### Herramienta de monitorización de procesos en Windows
process-forest is a tool that processes Microsoft Windows EVTX event logs that contain process accounting events and reconstructs the historical process heirarchies. That is, it displays the parent-child relationships among programs. When using this tool during an incident response engagement, identifying a reverse shell process quickly leads to the processes launched by the operator, and insight into how it may be maintaining persistence.
https://github.com/williballenthin/process-forest
### Monitoring Windows Console Activity
* https://www.fireeye.com/blog/threat-research/2017/08/monitoring-windows-console-activity-part-one.html
* https://www.fireeye.com/blog/threat-research/2017/08/monitoring-windows-console-activity-part-two.html

## Monitorizar servicios
### Analizar servicios con PowerShell
https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/
