# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Monitorización

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

## Introducción
### Encontrarse a uno mismo
```PowerShell
Get-EventLog Security | Where-Object Message -Match "asir1joselui"
```

### Registrar un evento cuando se logre realizar una conexión entre un cliente y un servidor mediante UDP (almacenar la dirección IP de la conexión del cliente o del servidor)
#### Server and client (Sockets UDP)
https://www.jesusninoc.com/12/29/server-and-client/
#### Escribir y ver un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/
#### Verificar en el registro de eventos que se ha realizado una conexión
```PowerShell
Get-EventLog Application | Where-Object Message -Match "192.168"
```
#### Solución (casi)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]"192.168.43.61",$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" -EventID 916 -EntryType Information -Message "192.168.43.108" -Category 2 -RawData 10,20')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
Invoke-Expression ([Text.Encoding]::ASCII.GetString($content))
```
#### Solución (final)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]"192.168.43.61",$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('hola')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" -EventID 916 -EntryType Information -Message "$endpoint | select adress" -Category 2 -RawData 10,20
```

## Display the top ten running processes - sorted by memory usage
https://www.commandlinefu.com/commands/view/15786/display-the-top-ten-running-processes-sorted-by-memory-usage

## easily strace all your apache processes
https://www.commandlinefu.com/commands/view/17621/easily-strace-all-your-apache-processes

## Bg, Fg, &, Ctrl-Z – 5 Examples to Manage Unix Background Jobs
https://www.thegeekstuff.com/2010/05/unix-background-job

## Analizar servicios con PowerShell
https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/

## The Win32_StartupCommand WMI class represents a command that runs automatically when a user logs onto the computer system
```PowerShell
Get-CimInstance -ClassName Win32_StartupCommand
```

## Monitorizar procesos
### 7. Gestión de procesos en PowerShell
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

## Monitorizar servicios
### Analizar servicios con PowerShell
https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/

## Monitorizar red
### Enabling DNS Logging for Windows Server 2012
http://support.moonpoint.com/network/dns/windows/logging/srvr2012.php

### Mostrar información sobre las reglas del Firewall de Windows con PowerShell
```PowerShell
$f = New-object -comObject HNetCfg.FwPolicy2
$f.Rules | Select-Object name,applicationname,localports,remoteports | Out-GridView
```

### Display list of blocked ports
```PowerShell
$f = New-object -comObject HNetCfg.FwPolicy2
$f.rules |  where {$_.action -eq "0"} | select name,applicationname,localports
```

## Process Monitor
https://docs.microsoft.com/en-us/sysinternals/downloads/procmon

## Herramienta de monitorización de procesos en Windows
process-forest is a tool that processes Microsoft Windows EVTX event logs that contain process accounting events and reconstructs the historical process heirarchies. That is, it displays the parent-child relationships among programs. When using this tool during an incident response engagement, identifying a reverse shell process quickly leads to the processes launched by the operator, and insight into how it may be maintaining persistence.
https://github.com/williballenthin/process-forest

## Monitoring Windows Console Activity
* https://www.fireeye.com/blog/threat-research/2017/08/monitoring-windows-console-activity-part-one.html
* https://www.fireeye.com/blog/threat-research/2017/08/monitoring-windows-console-activity-part-two.html

--------------------

# DLL
* Run PowerShell with rundll32. Bypass software restrictions https://github.com/p3nt4/PowerShdll
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-13.md
* https://www.jesusninoc.com/2018/04/15/ejecutar-microsoft-coff-binary-file-dumper-dumpbin-exe-desde-powershell/

# Integridad
## Comprobar si ha cambiado algún fichero utilizando la función hash SHA1
https://www.jesusninoc.com/2016/01/27/comprobar-si-ha-cambiado-algun-fichero-utilizando-la-funcion-hash-sha1/

--------------------

# WMIC

## Listar actualizaciones y almacenar en un fichero html
```MS-DOS
wmic qfe list full /format:htable > hotfixes.htm
```

## Examples of WMIC commands for Windows .NET SERVER Family 
https://www.cs.cmu.edu/~tgp/scsadmins/winadmin/WMIC_Queries.txt

## Enable RDP remotely via #wmic on #Windows 2008 and above: 
```MS-DOS
wmic /namespace:\\root\CIMV2\TerminalServices PATH Win32_TerminalServiceSetting WHERE (__CLASS !="") CALL SetAllowTSConnections 1
```

## WMIC.EXE Whitelisting Bypass - Hacking with Style, Stylesheets
https://subt0x11.blogspot.com.es/2018/04/wmicexe-whitelisting-bypass-hacking.html

## Living Off The Land Binaries And Scripts - (LOLBins and LOLScripts)
https://github.com/api0cradle/LOLBAS

## GTFOBins
GTFOBins is a curated list of Unix binaries that can be exploited by an attacker to bypass local security restrictions.
https://gtfobins.github.io/

--------------------

# Analizar datos en memoria

## Leer el contenido de un fichero en ASCII y representarlo en decimal
http://www.jesusninoc.com/2017/01/29/leer-el-contenido-de-un-fichero-en-ascii-y-representarlo-en-decimal/

## Crear un fichero de volcado de memoria de un proceso
http://www.jesusninoc.com/2016/03/04/crear-un-fichero-de-volcado-de-memoria-de-un-proceso/

## Buscar una cadena dentro de un fichero de volcado de memoria
http://www.jesusninoc.com/2016/03/13/buscar-una-cadena-dentro-de-un-fichero-de-volcado-de-memoria/

# Red

## Modificar datagramas UDP con SoftPerfect Network Protocol Analyzer
https://www.jesusninoc.com/2016/03/19/modificar-datagramas-udp-con-softperfect-network-protocol-analyzer/

## Building My Ideal Router For $50
https://blog.tjll.net/building-my-perfect-router/

## Automatizar con WinSCP
### Parameters for winscp.exe executable:
https://winscp.net/eng/docs/commandline

## Analizar datos en red
### La captura de tráfico 
http://www.elladodelmal.com/2018/03/amazon-dash-button-un-hack-para-enviar.html

## Compilation of commands, tips and scripts that helped me throughout Vulnhub, Hackthebox, OSCP and real scenarios
https://github.com/adon90/pentest_compilation

# Analizar datos
## USB
### USBPcap – USB Packet capture for Windows
https://www.jesusninoc.com/2016/05/01/usbpcap-usb-packet-capture-for-windows/
### Wireshark and USB
https://isc.sans.edu/forums/diary/Wireshark+and+USB/23457/
### Hackers exploit casino's smart thermometer to steal database info
https://mashable.com/2018/04/15/casino-smart-thermometer-hacked/
### Logran robar datos de un ordenador a través del cableado eléctrico
https://www.redeszone.net/2018/04/13/logran-robar-datos-ordenador-traves-del-cableado-electrico/

# Ofuscación
## Introducción a la ofuscación en PowerShell (3ª parte) (Ejemplo de utilización de directorios)
https://www.youtube.com/watch?v=MkAZammvhaM

## Ofuscación en PowerShell
https://www.jesusninoc.com/2017/12/01/ofuscacion-en-powershell/

# IoT
## Microsoft.PowerShell.IoT 0.1.0
https://www.powershellgallery.com/packages/Microsoft.PowerShell.IoT/0.1.0

# rundll32 + dll
```MS-DOS
rundll32.exe advpack.dll,RegisterOCX not_a_dll.txt:test.dll
rundll32.exe ieadvpack.dll,RegisterOCX not_a_dll.txt:test.dll
```
https://twitter.com/bohops/status/984437808185200640
