# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

--------------------------

# AD
## How to Disable PowerShell with Software Restriction Policies GPO
https://www.top-password.com/blog/disable-powershell-with-software-restriction-policies-gpo

# Registro
## EjemplosRegistroHardware.ps1
https://github.com/jesusninoc/PowerShell/blob/master/Registro/EjemplosRegistroHardware.ps1

# Auditoría
## Auditar AD
### PowerShell Script to perform a quick AD audit
https://github.com/phillips321/adaudit

## Eventos
### 10. Gestión del rendimiento en PowerShell (nivel intermedio)
https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
### Escribir y ver un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/
### EventLog
https://www.jesusninoc.com/eventlog/

## Auditoría de proceso de línea de comandos
https://docs.microsoft.com/es-es/windows-server/identity/ad-ds/manage/component-updates/command-line-process-auditing

--------------------------

# Examen
## Crear mediante scripts una estructura de Dominio parecida a la que tenemos en el Centro (solución Alejandro Aracil)
```PowerShell
# Crear una Unidades Organizativas:
New-ADOrganizationalUnit -Name "ESO" -Path "dc=red,dc=local"
New-ADOrganizationalUnit -Name "1ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "2ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "3ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "4ºESO" -Path "ou=ESO,dc=red,dc=local"
New-ADOrganizationalUnit -Name "Equipos" -Path "ou=ESO,dc=red,dc=local"

New-ADOrganizationalUnit -Name "BACH" -Path "dc=red,dc=local"
New-ADOrganizationalUnit -Name "1ºBACH" -Path "ou=BACH,dc=red,dc=local"
New-ADOrganizationalUnit -Name "2ºBACH" -Path "ou=BACH,dc=red,dc=local"
New-ADOrganizationalUnit -Name "Equipos" -Path "ou=BACH,dc=red,dc=local"

Start-Sleep -Seconds 1

# Crear GRUPOS A PARTIR DE UN FICHERO
gc Z:\GruposExamen.txt | %{
    New-ADGroup -name (($_).split(",")[0]) -GroupScope Global
}
Start-Sleep -Seconds 1

# Crear usuarios y meterlos en un grupo
gc Z:\UsuariosExamen.txt | %{
    new-aduser -name (($_).split(",")[0]) -sam (($_).split(",")[0]) -accountpassword (convertto-securestring "Retamar1a" -asplaintext -force) -enable $true
    Add-ADGroupMember (($_).split(",")[1]) -Members (($_).split(",")[0])
    }
Start-Sleep -Seconds 1

# Mover usuarios a una OU
Move-ADObject "cn=juan,cn=users,dc=red,dc=local" -TargetPath "ou=1ºESO,ou=ESO,dc=red,dc=local"
Move-ADObject "cn=pedro,cn=users,dc=red,dc=local" -TargetPath "ou=1ºESO,ou=ESO,dc=red,dc=local"
Move-ADObject "cn=lucia,cn=users,dc=red,dc=local" -TargetPath "ou=2ºBACH,ou=BACH,dc=red,dc=local"
Move-ADObject "cn=Pepito,cn=users,dc=red,dc=local" -TargetPath "ou=2ºBACH,ou=BACH,dc=red,dc=local"
Start-Sleep -Seconds 1

# Linkar GPOs
New-GPLink -name "QuitarCMD" -Target "ou=1ºESO,ou=ESO,dc=red,dc=local" -Enforced Yes
New-GPLink -name "QuitarPanel" -Target "ou=1ºESO,ou=ESO,dc=red,dc=local" -Enforced Yes
New-GPLink -name "FondoDeEscritorio" -Target "ou=Equipos,ou=ESO,dc=red,dc=local" -Enforced Yes

New-GPLink -name "QuitarCMD" -Target "ou=2ºBACH,ou=BACH,dc=red,dc=local" -Enforced Yes
New-GPLink -name "QuitarPanel" -Target "ou=2ºBACH,ou=BACH,dc=red,dc=local" -Enforced Yes
New-GPLink -name "FondoDeEscritorio" -Target "ou=Equipos,ou=BACH,dc=red,dc=local" -Enforced Yes
```
## Otra solución con ejemplos de creación de políticas de grupo (Ignacio Barranquero)

```PowerShell
#Estructura, usuarios y políticas del AD

#Unidades Organizativas

    #Equipos

    New-ADOrganizationalUnit -Name "Ordenadores Colegio" -Path "DC=red,DC=local"
    New-ADOrganizationalUnit -Name "LTI" -Path "OU=Ordenadores Colegio,DC=red,DC=local"
    New-ADOrganizationalUnit -Name "LTIALUMNOS" -Path "OU=LTI,OU=Ordenadores Colegio,DC=red,DC=local"
    New-ADOrganizationalUnit -Name "LTINOALUMNOS" -Path "OU=LTI,OU=Ordenadores Colegio,DC=red,DC=local"

    (1..3) | %{
        New-ADOrganizationalUnit -Name $_ -Path "OU=LTIALUMNOS,OU=LTI,OU=Ordenadores Colegio,DC=red,DC=local"
    }

    #Alumnos

    New-ADOrganizationalUnit -Name "Usuarios" -Path "DC=red,DC=local"
    New-ADOrganizationalUnit -Name "Alumnos" -Path "OU=Usuarios,DC=red,DC=local"

    Set-ADDefaultDomainPasswordPolicy -ComplexityEnabled $False -Identity red.local #Deshabilitar complejidad de contraseña

    Import-Csv C:\Users\Administrator\Desktop\alumnos.txt | %{
        
        $curso=$_.curso

        New-ADOrganizationalUnit -Name $curso -Path "OU=Alumnos,OU=Usuarios,DC=red,DC=local"

#Usuarios y grupos

        New-ADGroup -Name $curso -GroupScope DomainLocal -Path "OU=$curso,OU=Alumnos,OU=Usuarios,DC=red,DC=local"

        New-ADUser -Name $_.nombre -SamAccountName $_.nombre -DisplayName $_.nombre `
        -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.password -AsPlainText -force) `
        -PassThru -UserPrincipalName $_.nombre -Path "OU=$curso,OU=Alumnos,OU=Usuarios,DC=red,DC=local"

        Add-ADGroupMember -Identity "CN=$curso,OU=$curso,OU=alumnos,OU=Usuarios,DC=red,DC=local" $_.nombre
    }


#Políticas de grupo


#Deshabilitar Windows Defender

New-GPO -Name "Windows Defender" -Comment "Deshabilita Windows Defender Antivirus"
Set-GPRegistryValue -Name "Windows Defender" -Key "HKLM\Software\Policies\Microsoft\Windows Defender" -ValueName DisableAntiSpyware -Type DWord -Value 1
New-GPLink -Name "Windows Defender" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar Cortana

New-GPO -Name "Cortana" -Comment "Deshabilita las funciones de Cortana"
Set-GPRegistryValue -Name "Cortana" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Search" -ValueName AllowCortana -Type DWord -Value 0
Set-GPRegistryValue -Name "Cortana" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Search" -ValueName AllowCortanaAboveLock -Type DWord -Value 0
Set-GPRegistryValue -Name "Cortana" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows\Windows Search" -ValueName AllowSearchToUseLocation -Type DWord -Value 0
New-GPLink -Name "Cortana" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar animación del primer inicio de sesión

New-GPO -Name "Animación de inicio" -Comment "Deshabilita la animación del primer inicio de sesión"
Set-GPRegistryValue -Name "Animación de inicio" -Key "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System" -ValueName EnableFirstLogonAnimation -Type DWord -Value 0
New-GPLink -Name "Animación de inicio" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar Firewall

New-GPO -Name "Firewall" -Comment "Deshabilita el Firewall"
Set-GPRegistryValue -Name "Firewall" -Key "HKLM\SOFTWARE\Policies\Microsoft\WindowsFirewall\DomainProfile" -ValueName EnableFirewall -Type DWord -Value 0
Set-GPRegistryValue -Name "Firewall" -Key "HKLM\SOFTWARE\Policies\Microsoft\WindowsFirewall\StandardProfile" -ValueName EnableFirewall -Type DWord -Value 0
New-GPLink -Name "Firewall" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

#Deshabilitar Notificaciones

New-GPO -Name "Notificaciones equipo" -Comment "Deshabilita las notificaciones"
Set-GPRegistryValue -Name "Notificaciones equipo" -Key "HKLM\SOFTWARE\Policies\Microsoft\Windows Defender Security Center\Notifications" -ValueName DisableNotifications -Type DWord -Value 1
New-GPLink -Name "Notificaciones equipo" -Target "OU=Ordenadores Colegio,DC=red,DC=local"

New-GPO -Name "Notificaciones usuario" -Comment "Deshabilita las notificaciones"
Set-GPRegistryValue -Name "Notificaciones usuario" -Key "HKCU\Software\Policies\Microsoft\Windows\CurrentVersion\PushNotifications" -ValueName NoToastApplicationNotification -Type DWord -Value 1
Set-GPRegistryValue -Name "Notificaciones usuario" -Key "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer" -ValueName TaskbarNoNotification -Type DWord -Value 1
Set-GPRegistryValue -Name "Notificaciones usuario" -Key "HKCU\Software\Policies\Microsoft\Windows\Explorer" -ValueName DisableNotificationCenter -Type DWord -Value 1
New-GPLink -Name "Notificaciones usuario" -Target "OU=Usuarios,DC=red,DC=local"
```
