# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

--------------------------

# Directivas de grupo

## Configurar
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas
  - No reemplazar y deshabilitar
  
## Teoría
- Bloquear herencia.
- Forzar una directiva: al haber forzado la aplicación de la GPO, en este caso sobrepasará el bloqueo de herencia https://windowserver.wordpress.com/2017/07/11/directivas-de-grupo-gpo-herencia-forzado-y-resolucin-de-conflictos/.

## Práctica
```PowerShell
Get-GPO -Name "ScreenSaverTimeOut" | Get-GPOReport -ReportType HTML -Path $Home\report.html
Invoke-Item $Home\report.html

# Configure Advanced Settings
## Inherited Group Policies
Get-GPInheritance -Target "ou=people,dc=pagr,dc=inet"

## Blocking inheritance
Set-GPInheritance -Target "ou=people,dc=pagr,dc=inet" -IsBlocked 1

## Enforcing Group Policies
Set-GPLink -Name "Default Domain Policy" -Target "dc=pagr,dc=inet" -Enforced Yes
```

## Manual del editor de GPO local en Windows 10
https://www.solvetic.com/tutoriales/article/2655-manual-del-editor-de-gpo-local-en-windows-10/
