# Examen de evaluación
## Realizar un script que sea una tarea programada que almacene información sobre la situación actual de los sistemas operativos que hay en una red (Windows y Linux), teniendo en cuenta:
- Para detectar los ficheros necesitas utilizar expresiones regulares.
- Buscar usuarios mediante expresiones regulares.
- Restaurar un usuario leyendo del fichero la información.

Explica TODOS los pasos que realizas.

## Ayuda
### Listar dll, msi, exe
```PowerShell
ls c:\ *.exe -Recurse | %{
    $_.FullName
    Copy-Item $_.FullName -Destination prueba3 -whatif
}
```
### Sintaxis de las expresiones regulares
* https://ss64.com/ps/syntax-regex.html
* https://www.ediciones-eni.com/open/mediabook.aspx?idR=2be2f69e210d8959b4f48f839088e685
### Mostrar si un usuario pertenece a un grupo
```PowerShell
foreach($grupos in Get-LocalGroup)
{
    foreach($usuarios in Get-LocalGroupMember($grupos.name))
    {
        if($usuarios -match "administrador")
        {
            $grupos
        }
    }
}
```
### Ejemplo de expresión regular para seleccionar usuarios que empiezan por una letra
```PowerShell
Get-LocalUser | select name | %{
    $_.name -match '^[ag]'
}

Get-LocalUser [ag]* | select name 
```
### Restaurar usuarios creados anteriormente
```PowerShell
(Get-LocalUser).name | out-file .\usuarios3.txt

(gc .\usuarios3.txt) | % {
    New-LocalUser $_ -whatif -NoPassword
}

(Get-LocalUser).name | % {
    New-LocalUser $_ -whatif -NoPassword
}
```
### Poner bonito
```PowerShell
Function showmenu {
    Clear-Host
    Write-Host "Starting Menu..."
    Write-Host "1. Search"
    Write-Host "2. Create"
    Write-Host "3. Delete"
    Write-Host "4. Exit"
}

showmenu

while(($inp = Read-Host -Prompt "Select an option") -ne "4"){

switch($inp){
        1 {
            Clear-Host
            Write-Host "------------------------------";
            Write-Host "Search account"; 
            Write-Host "------------------------------";
            pause;
            break
        }
        2 {
            Clear-Host
            Write-Host "------------------------------";
            Write-Host "Create account";
            Write-Host "------------------------------";
            pause; 
            break
        }
        3 {
            Clear-Host
            Write-Host "------------------------------";
            Write-Host "Remove account";
            Write-Host "------------------------------"; 
            pause;
            break
            }
        4 {"Exit"; break}
        default {Write-Host -ForegroundColor red -BackgroundColor white "Invalid option. Please select another option";pause}
        
    }

showmenu
}
```
---------------

# Resolver las siguientes situaciones en Windows y Linux mediante scripts
Referencia Módulo profesional: Implantación de sistemas operativos

https://www.boe.es/boe/dias/2010/02/25/pdfs/BOE-A-2010-3028.pdf

- Analizar información sobre arranque (ficheros que están relacionados)
- Analizar información sobre la arquitectura y procesador en general
- Extraer información del registro, licencias
- Verificar si está actualizado el sistema, qué parches tiene
- Analizar registro del sistema para detectar fallos
- Crear procedimiento para evitar que aparece un usuario nuevo (tener en cuenta usuarios predeterminados)
- Configuración de red
- Optimizar el sistema analizando información de procesos y servicios
- Crear un disco virtual cifrado (montarlo, desmontarlo y comprimirlo)
- Buscar información del sistema analizando TODOS los ficheros que haya en el sistema
- Rendimiento en general
- Procedimiento de copias de seguridad (con recuperación)
- Proyecto completo de estructura de dominio (equipos, usuarios y GPOS)
- Analizar directivas de grupo
- Monitorizar en tiempo real con sucesos
- Aditoría completa del sistema
- Detectar un fallo hardware e intentar solucionar el problema
- Controlar versiones de programas remotamente
- Realizar un inventario de software
- Gestionar un servicio de tickets de forma automática
