# Administración de recursos compartidos:
- Instalación y configuración de servicios
- Administración del acceso a recursos. SMB/CIFS. SAMBA. NFS.
- Grupos de trabajo.
- Permisos de red. Permisos locales. Herencia. Permisos efectivos.

--------------

# Copiar el contenido de todas las carpetas compartidas que tengas en la red a una carpeta

# Crear una carpeta compartida en Linux

# Comunicar dos ordenadores (mover el ratón), el primer ordenador guarda las posiciones del ratón en un fichero que está almacenado en la carpeta compartida de Linux y el otro ordenador lee la posicíón que ha escrito el primer ordenador y la respresenta en la pantalla

--------------

# Ejecicios sobre almacenamiento (discos, carpetas compartidas, etc.)
## PowerShell
### Crear un script en que detecta unidades compartidas y mueve los ficheros que contienen a otra unidad
#### Detectar unidades
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk”)
```
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk”).DeviceID
```
```PowerShell
GET-WMIOBJECT –query “SELECT * from win32_logicaldisk where DriveType = 3”
```
```PowerShell
GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID
```
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID
```
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "q:"
```
```PowerShell
Get-ChildItem (GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
```
```PowerShell
$unidad=(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
$unidad
```
```PowerShell
$unidad=(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
$unidad
Get-ChildItem $unidad
```
```PowerShell
$unidad=(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
$unidad
Get-ChildItem $unidad -Recurse
```
```PowerShell
Get-ChildItem c:\ -Recurse *.txt
Get-ChildItem c:\ -Recurse *.txt | %{copy-Item $_ $dondequierase}
```

### Create a drive mapped to a network share
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/new-psdrive?view=powershell-6
```PowerShell
New-PSDrive -Name "P" -PSProvider "FileSystem" -Root "\\Server01\Public"
```

### PowerShell: Partition verkleinern und neu partitionieren (reducir tamaño de partición y crear una nueva)
https://sid-500.com/2017/09/03/powershell-festplatte-verkleinern-und-neu-partitionieren/

### Recuperar particiones eliminadas
http://www.redeszone.net/windows/como-recuperar-particiones-eliminadas-o-borradas-con-testdisk/

### Hiren's BootCD
http://www.hiren.info/pages/bootcd

## Linux
### Differences between /dev/sda and /dev/sda1
http://serverfault.com/questions/338937/differences-between-dev-sda-and-dev-sda1

### Obtener tipo de partición, UUID y el identificador del nodo. BLKID
```Bash
blkid
```
### Tip: Using UUID for mounting disks, the convenient way
https://access.redhat.com/discussions/1573543

### Muestra información referente a los dispositivos conectados a los puertos USB
```Bash
lsusb
```
### Repaso de ficheros de configuración en Linux

#### Network
http://www.yolinux.com/TUTORIALS/LinuxTutorialNetworking.html

#### File: /etc/network/interfaces
```Bash
auto lo
iface lo inet loopback
auto eth0
iface eth0 inet static
        address 208.88.34.106
        netmask 255.255.255.248
        broadcast 208.88.34.111
        network 208.88.34.104
        gateway 208.88.34.110
```

### Montar un sistema SMB
```Bash
sudo mount -t cifs //10.0.1.101/copias /mnt/backup
```

### Sincronizar carpetas montadas
```Bash
rsync -rutv --progress --bwlimit=40000 /srv/carpeta/ /mnt/backup/carpeta/
rsync -rutvl --progress --bwlimit=40000 /var/www/web/ /mnt/backup/www
```

### Compartir carpetas en Linux
#### Access the Windows Share from Linux
https://www.howtogeek.com/176471/how-to-share-files-between-windows-and-linux/

```Bash
sudo apt-get install cifs-utils
mkdir ~/Desktop/Windows-Share 
sudo mount.cifs //WindowsPC/Share /home/jes/Desktop/Windows-Share -o user=jesusninoc
````

#### Create a Share on Linux and Access It from Windows
```Bash
sudo apt-get install samba
smbpasswd -a jesusninoc
mkdir ~/Desktop/Share
sudo vi /etc/samba/smb.conf
[<folder_name>]
path = /home/<user_name>/<folder_name> 
available = yes 
valid users = <user_name> 
read only = no 
browsable = yes 
public = yes 
writable = yes
sudo service smbd restart
```

### RAID en Linux
https://www.computernetworkingnotes.com/rhce-study-guide/how-to-configure-raid-in-linux-step-by-step-guide.html
```Bash
mdadm -Cv /dev/md0 -l0 -n2 -c128 /dev/sdb1 /dev/sdc1
```

### Conectarse desde GNU/Linux a una carpeta Windows compartida (Samba)
http://fraterneo.blogspot.com.es/2011/06/conectarse-desde-gnulinux-una-carpeta.html

### Clonar con Clonezilla
http://clonezilla.org/

--------------

# Carpetas compartidas
## The Win32_Share class represents a shared resource on a computer system running Windows
```PowerShell
gwmi Win32_Share
```
```PowerShell
get-WmiObject -class Win32_Share -computer dc1 -Credential dominio\administrador
```
## Network resources
```PowerShell
net view \\dc1
```
## Listing Network Drives
* https://community.idera.com/database-tools/powershell/powertips/b/tips/posts/listing-network-drives
```PowerShell
$obj = New-Object -ComObject WScript.Network
$result = $obj.EnumNetworkDrives() 
Foreach ($entry in $result)
{
    $letter = $entry
    $null = $foreach.MoveNext()
    $path = $foreach.Current
  
  
    [PSCustomObject]@{
        DriveLetter = $letter
        UNCPath = $path
    }
}
```
## Get shares that are connected to a specific server
https://docs.microsoft.com/en-us/powershell/module/smbshare/get-smbshare?view=win10-ps
```PowerShell
Get-SmbShare -ScopeName "Contoso-FS"
```

--------------

# Posibles preguntas para el examen

- Pedir un proceso
  - Comprobar la ruta y el hash (hay un listado de hash para los programas que hay en el sistema)
  - Comprobar si hay algún drivers cambiado (hay un listado de hash para los drivers)
- Instalar programas en Ubuntu leyendo desde un fichero
- Ver versión de programas instalados, los antiguos hay que actualizarlos
- Hay un fallo en arranque, ¿qué puedes comprobar?
- Funciones del sistema operativo
- Actualización
- Control de acceso a programas
- Controladores, drivers
- GPT fallo
- Instalar y actualizar
- Registro de eventos
- Ficheros necesarios para que arranque un sistema
- Qué proceso realizas para crear un usuario
- Crear y añadir usuarios
- El usuario con más privilegios
- Habilitar usuarios
- Seguridad en contraseñas
- Problema con rutas, LFI
- Permisos, herencia, permisos efectivos
- Cambiar dueño usuario
- Carpetas compartidas
- Directivas de seguridad y auditorías LOCALES

--------------

# MySQL desde PowerShell

## Conectar a MySQL desde PowerShell
https://www.jesusninoc.com/2017/12/13/conectar-a-mysql-desde-powershell/

## Crear una tabla en una base de datos en MySQL con PowerShell
https://www.jesusninoc.com/2017/01/13/crear-una-tabla-en-una-base-de-datos-en-mysql-con-powershell/

## Insertar valores en una tabla de una base de datos en MySQL con PowerShell
https://www.jesusninoc.com/2017/01/17/insertar-valores-en-una-tabla-de-una-base-de-datos-en-mysql-con-powershell/

## Insert into MySQL database
https://www.jesusninoc.com/2015/12/14/insert-into-mysql-database/

## Almacenar la información enviada entre un cliente y un servidor en una base de datos MySQL con PowerShell
https://www.jesusninoc.com/2017/01/15/almacenar-la-informacion-enviada-entre-un-cliente-y-un-servidor-en-una-base-de-datos-mysql-con-powershell/

## Ejercicios curso MySQL con PowerShell
https://www.jesusninoc.com/2017/02/20/ejercicios-curso-mysql-con-powershell/

## Análisis de una petición a MySQL con SoftPerfect Network Protocol Analyzer
https://www.jesusninoc.com/2017/03/31/analisis-de-una-peticion-a-mysql-con-softperfect-network-protocol-analyzer/
