# Administración de software de base

 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
   - Archivos de red sin conexión.
   - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
   - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Repaso de ficheros de configuración en Linux

## Network
http://www.yolinux.com/TUTORIALS/LinuxTutorialNetworking.html

## File: /etc/network/interfaces
```Bash
auto lo
iface lo inet loopback

auto eth0
iface eth0 inet static
        address 208.88.34.106
        netmask 255.255.255.248
        broadcast 208.88.34.111
        network 208.88.34.104
        gateway 208.88.34.110
```

-----------------

# Sort IPv4 Addresses Correctly
http://community.idera.com/powershell/powertips/b/tips/posts/sort-ipv4-addresses-correctly

# Recorrer rango direcciones IP
* https://www.jesusninoc.com/2017/07/14/recorrer-un-rango-de-direcciones-ip/
* https://www.jesusninoc.com/2017/07/06/recorrer-direcciones-ip/
* https://github.com/jesusninoc/PowerShell/blob/master/Red/EjemplosRed.ps1

# Puertos abiertos
## Si está abierto parece que no hay resultado
```PowerShell
$tcpobject = New-Object System.Net.Sockets.TcpClient 
$connect = $tcpobject.BeginConnect("127.0.0.1",25,$null,$null)
    
# wait for the connection no longer than $timeoutMilliseconds 
$wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false)
$tcpobject.EndConnect($connect) 
```
## Si no está abierto hay resultado
```PowerShell
$tcpobject = New-Object System.Net.Sockets.TcpClient 
$connect = $tcpobject.BeginConnect("127.0.0.1",215,$null,$null)
    
# wait for the connection no longer than $timeoutMilliseconds 
$wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false)
$tcpobject.EndConnect($connect) 
```
## Scanning Ports
* https://community.idera.com/database-tools/powershell/powertips/b/tips/posts/scanning-ports
```PowerShell
function Get-PortInfo
{
    param
    (
        [Parameter(Mandatory)]
        [Int]
        $Port,
    
        [Parameter(Mandatory)]
        [Int]
        $TimeoutMilliseconds,
        
        [String]
        $ComputerName = $env:COMPUTERNAME
    )
  
    # try and establish a connection to port async
    $tcpobject = New-Object System.Net.Sockets.TcpClient 
    $connect = $tcpobject.BeginConnect($computername,$port,$null,$null)
    
    # wait for the connection no longer than $timeoutMilliseconds 
    $wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false) 
    
    # return rich information
    $result = @{
        ComputerName = $ComputerName
    }
    
    if(!$wait) { 
        # timeout
        $tcpobject.Close() 
        $result.Online = $false
        $result.Error = 'Timeout'
    } else { 
        try { 
            # try and complete the connection
            $null = $tcpobject.EndConnect($connect)
            $result.Online = $true
        }
        catch { 
            $result.Online = $false
        } 
        $tcpobject.Close() 
    } 
    $tcpobject.Dispose()
    
    [PSCustomObject]$result
} 
```

-----------------

# DNS
* https://www.jesusninoc.com/dns/

-----------------

# Firewall
## Enable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/16/enable-the-microsoft-windows-firewall/
## Disable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/15/disable-the-microsoft-windows-firewall/
## Finding Open Firewall Ports
```PowerShell
$firewall = New-object -ComObject HNetCfg.FwPolicy2
$firewall.Rules |  Where-Object {$_.Action -eq 0} | 
    Select-Object Name, ApplicationName,LocalPorts
```
## Log del Firewall
```Cmd
%systemroot%\system32\LogFiles\Firewall\pfirewall.log
```

-----------------

# BREACH: REVIVING THE CRIME ATTACK
## YOEL GLUCK, NEAL HARRIS, AND ANGELO (ANGEL) PRADO ´
http://breachattack.com/resources/BREACH%20-%20SSL,%20gone%20in%2030%20seconds_orig.pdf

# Ping: Request timed out vs. Destination Host unreachable
https://sid-500.com/2017/08/28/ping-request-timed-out-vs-destination-host-unreachable/ 

# Defending against Sequence Number Attacks
https://tools.ietf.org/html/rfc6528

# Enviar TCP con Python
```Python
from scapy.all import *
send((IP(dst="127.0.0.1",src="192.168.1.157")/TCP(dport=6969)/"Hello"))
```
