# Ejercicio de PowerShell | Adivinar un número aleatorio que genera PowerShell
https://www.youtube.com/watch?v=Od5Y10PIz8Q

-----------------

# Administración de software de base

 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Repaso básico de red
## Configurar IP en Windows
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Bash
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## Conectar con Linux por SSH
https://www.jesusninoc.com/2017/09/26/ejecutar-un-script-de-powershell-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/

## Guardar un fichero html preguntando al usuario qué título quiere
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html
start chrome .\web.html

## Crear y ejecutar un script de Bash realizando una conexión SSH desde PowerShell en Windows
https://www.jesusninoc.com/2017/09/22/crear-y-ejecutar-un-script-de-bash-realizando-una-conexion-ssh-desde-powershell-en-windows/

## Crear y ejecutar un script de Bash realizando una conexión SSH a un contenedor Docker desde PowerShell en Windows
https://www.jesusninoc.com/2017/10/21/crear-y-ejecutar-un-script-de-bash-realizando-una-conexion-ssh-a-un-contenedor-docker-desde-powershell-en-windows/

# Conceptos de red
## TTL
Para evitar que una petición ping viaje de forma ilimitada por internet, en cada una de ellas se establece un Time To Live (TTL), que representa el número de saltos que ha dado el paquete de host en host por internet hasta alcanzar su destino. En cada salto, el TTL se decrementa en una unidad, y si en algún momento llega a 0 entonces el paquete se descarta y el host devuelve un error al origen.
## ¿Por que me cambia el valor TTL dependiendo de a quien haga ping?
https://foro.elhacker.net/redes/duda_iquestpor_que_me_cambia_el_valor_ttl_dependiendo_de_a_quien_haga_ping-t69071.0.html
## Cómo usar TRACERT para solucionar problemas de TCP/IP en Windows
https://support.microsoft.com/es-es/help/314868/how-to-use-tracert-to-troubleshoot-tcp-ip-problems-in-windows
## Ping continuado a servidores de tarificación por byte consumido
https://www.jesusninoc.com/2004/06/02/ping-continuado-a-servidores-de-tarificacion-por-byte-consumido/
## Modificar TTL para un solo registro en la zona DNS
http://nextadmin.blogspot.com.es/2014/10/modificar-ttl-para-un-solo-registro-en.html
## Cmdlets for TCP/IP Model Layers (Windows)
https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-11.md
## ifconfig vs ip (Linux) 
https://p5r.uk/blog/2010/ifconfig-ip-comparison.html
## Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
## Almacenar la información enviada entre un cliente y un servidor en una base de datos MySQL con PowerShell
https://www.jesusninoc.com/2017/01/15/almacenar-la-informacion-enviada-entre-un-cliente-y-un-servidor-en-una-base-de-datos-mysql-con-powershell/
## Modificar datagramas UDP con SoftPerfect Network Protocol Analyzer
https://www.jesusninoc.com/2016/03/19/modificar-datagramas-udp-con-softperfect-network-protocol-analyzer/
## Network
https://www.jesusninoc.com/network
## ATM and Frame Relay Services

### Service Category
- Constant Bit Rate (CBR):  Circuit emulation, videoconferencing,
- Real-Time Variable Bit Rate (rt-VBR): Compressed video/audio
- Non-Real-Time Variable Bit Rate (nrt-VBR): Critical data
- Available Bit Rate (ABR): LAN, interconnection,
- Unspecified Bit Rate (UBR) File transfer, message transfer

http://www.csd.uoc.gr/~hy536/atm_fr.pdf

### Virtual Paths and Virtual Channels
- Transmission Path
- Virtual Channel
- Virtual Path

https://technet.microsoft.com/en-us/library/cc978149.aspx
