# Repaso para realizar scripts en Linux

## Resumen de comandos para examen liberatorio (Linux)
https://github.com/jesusninoc/Bash/blob/master/Repaso/ResumenComandosExamenLiberatorio

## Repaso scripting (extraer caracteres de cadenas)
```Bash
short=$(echo "${long}" | cut -c1-2)
short=$(echo "${long}" | head -c2)
short=$(echo "${long}" | awk '{print substr ($0, 0, 2)}')
short=$(echo "${long}" | sed 's/^\(..\).*/\1/')
```

## Partir una cadena por un cáracter determinado
```bash
echo 'hola:adios' | cut -d ':' -f1
```
## Mostrar campos específicos del fichero
```bash
echo "1 Juan Director Tecnología 3000€" > empleados.txt
echo "2 Pedro Becario Web 1000€" >> empleados.txt
awk '{print $2,$5;}' empleados.txt
```
## Sumar los valores de las columnas de un fichero
```bash
echo "1 100" > valor.txt
echo "2 300" >> valor.txt
cat valor.txt  | awk '{ sum += $2 } END { print sum }'
```
## Sumar los valores de las columnas de un fichero si se cumple una condición
```bash
echo "1 nivel1 100" > valor.txt
echo "2 nivel2 300" >> valor.txt
echo "3 nivel1 300" >> valor.txt
cat valor.txt  | awk ' $2 == "nivel1" { sum += $3 } END { print sum }'
```

## Ejemplos y trucos para el lenguaje de programación AWK
http://wiki.woop.es/AWK

--------------

# Utilizar xargs
Definir donde se van a definir los parámetros
```bash
ls | xargs -I ARG echo fichero ARG fichero
```
Definir donde se van a definir los parámetros
```bash
echo "después" | xargs echo "antes"
echo "antes" | xargs -i echo {} "después"
```
Mostrar los parámetros 1 y 2
```bash
cat fichero.txt | xargs -l bash -c 'echo this is first:$0 second:$1'
```
Asignar permisos leyendo desde un fichero el nombre y el permiso en octal
```bash
cat fichero.txt | xargs bash -c 'chmod $0 $1'
```

--------------

# Seguridad en Windows
## Windows Privilege Escalation Guide
* http://www.sploitspren.com/2018-01-26-Windows-Privilege-Escalation-Guide/
* http://www.hackingarticles.in/post-exploitation-using-wmic-system-command/
* http://www.hackingarticles.in/manual-post-exploitation-windows-pc-system-command/
* https://www.jesusninoc.com/2016/10/09/windows-post-exploitation-cmdlets-execution-powershell/

## mimikatz
mimikatz is a tool I've made to learn C and make somes experiments with Windows security.
It's now well known to extract plaintexts passwords, hash, PIN code and kerberos tickets from memory. mimikatz can also perform pass-the-hash, pass-the-ticket or build Golden tickets.
https://github.com/gentilkiwi/mimikatz

## Mimikatz on Windows 10
https://astr0baby.wordpress.com/2018/01/30/running-latest-x64-mimikatz-on-windows-10/

## SharpWeb: un proyecto en .NET 2.0 para obtener las contraseñas guardadas en Google Chrome, Mozilla Firefox y Microsoft Internet Explorer/Edge
https://www.hackplayers.com/2018/12/sharpweb-recupera-credenciales-navegadores.html

## Deshabilitar UAC desde PowerShell
https://www.jesusninoc.com/2018/01/15/deshabilitar-uac-desde-powershell/

## Windows 10: (Otro) Bypass (más) de UAC usando AppPaths y sdctl.exe #Windows10 #Hacking #pentesting
http://www.elladodelmal.com/2017/03/windows-10-otro-bypass-mas-de-uac.html

## control.exe will load an unsigned, Alternate Data Stream (ADS) reflective DLL to bypass #AppLocker #RedTeam
https://twitter.com/bohops/status/954466315913310209

## Ejecutar PowerShell como administrador en Base64
https://www.jesusninoc.com/2016/11/23/ejecutar-powershell-como-administrador-en-base64/

## Registro básico
https://norfipc.com/inf/manual-registro.html

## Dumping Windows Password Hashes Using Metasploit
https://www.utc.edu/center-information-security-assurance/pdfs/4660-lab6.pdf

## Cain y Abel
http://www.oxid.it/cain.html

## Cracking Passwords Version 1.1
https://repo.zenk-security.com/Reversing%20.%20cracking/Cracking_Passwords_Guide.pdf

## [Spanish] HackBack - A DIY Guide
https://www.exploit-db.com/papers/41914/

## Download: Notify me, if someone is added to the Domain Admins group
https://sid-500.com/downloads/

--------------

# Seguridad en Linux
## Linux Shell script to add a user with a password to the system
https://www.cyberciti.biz/tips/howto-write-shell-script-to-add-user.html
