# Proyecto: simular el funcionamieto del DNS en los años 70

# Ayuda para realizar el proyecto
## 9. Gestión de la red en PowerShell (nivel intermedio)
https://www.jesusninoc.com/07/09/9-gestion-de-la-red-en-powershell/

---------------------------------------

# Proyecto: analizar información de consultas DNS (realizar distintas peticiones de forma detallada de tipo A, NS, MX)

# Ayuda para realizar el proyecto
## 9. Gestión de la red en PowerShell (nivel intermedio)
https://www.jesusninoc.com/07/09/9-gestion-de-la-red-en-powershell/
## Cómo realizar consultas DNS con el nslookup de Windows
http://systemadmin.es/2010/09/como-realizar-consultas-dns-con-el-nslookup-de-windows

---------------------------------------

# Proyecto: analizar y establecer un orden de direcciones IP de una red (teniendo en cuenta por ejemplo APIPA o DHCP)

# Ayuda para realizar el proyecto
## 9. Gestión de la red en PowerShell (nivel intermedio)
https://www.jesusninoc.com/07/09/9-gestion-de-la-red-en-powershell/
## APIPA (Automatic Private Internet Protocol Addressing)
https://es.wikipedia.org/wiki/Automatic_Private_Internet_Protocol_Addressing

---------------------------------------

# Proyecto: analizar información de los distintos protocolos de la red (DNS, LLMNR, DHCP, HTTP, FTP, SMTP, CUPS)

# Ayuda para realizar el proyecto
## 9. Gestión de la red en PowerShell (nivel intermedio)
https://www.jesusninoc.com/07/09/9-gestion-de-la-red-en-powershell/
## Wireshark
https://www.jesusninoc.com/wireshark/
## Practical Packet Analysis, 3rd Edition
https://nostarch.com/packetanalysis3
## ANÁLISIS DE TRÁFICO CON WIRESHARK
https://www.incibe.es/extfrontinteco/img/File/intecocert/EstudiosInformes/cert_inf_seguridad_analisis_trafico_wireshark.pdf
## Wireshark User’s Guide
https://www.wireshark.org/docs/wsug_html_chunked/
## Download the capture files for this book (.zip)
https://nostarch.com/packetanalysis3
## Cómo realizar consultas DNS con el nslookup de Windows
http://systemadmin.es/2010/09/como-realizar-consultas-dns-con-el-nslookup-de-windows
## APIPA (Automatic Private Internet Protocol Addressing)
https://es.wikipedia.org/wiki/Automatic_Private_Internet_Protocol_Addressing
## Análisis de conexiones de red
https://www.jesusninoc.com/2017/05/01/analisis-de-conexiones-de-red/
## ¿Qué podemos analizar en la red con Wireshark?
https://github.com/jesusninoc/ClasesSeguridad/blob/master/2018-02-21.md
## Servidor dhcp en Windows 2008 Server
http://informatica.gonzalonazareno.org/plataforma/mod/resource/view.php?id=4212

---------------------------------------

# Proyecto: crear, firmar y ejecutar un script remotamente

# Ayuda para realizar el proyecto
## Creates a new self-signed certificate
https://www.jesusninoc.com/11/06/creates-a-new-self-signed-certificate/
## Exports a certificate to a Personal Information Exchange (PFX) file
https://www.jesusninoc.com/11/18/exports-a-certificate-to-a-personal-information-exchange-pfx-file/
## Set-AuthenticodeSignature: adds an digital signature to a PowerShell script or other file
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.security/set-authenticodesignature?view=powershell-6
## How to Add a Computer to the TrustedHosts List
http://winintro.ru/windowspowershell2corehelp.en/html/f23b65e2-c608-485d-95f5-a8c20e00f1fc.htm
## Ejecutar un cmdlet remotamente en un equipo del dominio
https://www.jesusninoc.com/07/21/ejecutar-un-cmdlet-remotamente-en-un-equipo-del-dominio/

---------------------------------------

# Proyecto: descargar de web
# Ayuda para realizar el proyecto
## Limitar la recursividad en Get-ChildItem con el parámetro -Depth
https://www.jesusninoc.com/2017/11/11/limitar-la-recursividad-en-get-childitem-con-el-parametro-depth/
## DESCARGA EL CONTENIDO DIARIO DE PASTEBIN CON PYTHON
http://blog.quantika14.com/blog/2018/12/10/descargar-pastebin-diario/
## Obtener información sobre un servidor web con PowerShell
https://www.jesusninoc.com/02/01/obtener-informacion-sobre-un-servidor-web-con-powershell/

---------------------------------------

# Proyecto: crear un sistemas de gestión de correo
# Ayuda para realizar el proyecto
## Instalar hMailServer (IMAP, SMTP y POP3)
https://www.jesusninoc.com/01/12/instalar-hmailserver-imap-smtp-y-pop3/
## SENDING OR VIEWING EMAILS USING TELNET
https://mediatemple.net/community/products/dv/204404584/sending-or-viewing-emails-using-telnet

---------------------------------------

# Proyecto: ransomware
# Ayuda para realizar el proyecto
## Simular ransomware
https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-17.md#simular-ransomware
## Simular ransomware y subir por SSH
https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-17.md#simular-ransomware-y-subir-por-ssh
## ID Ransomware
Suba una nota de rescate y/o una muestra de archivo cifrado para identificar el ransomware que ha cifrado sus datos.
https://id-ransomware.malwarehunterteam.com/index.php?lang=es_ES

---------------------------------------

# Proyecto: crear un fichero XML con información sobre el sistema de archivos

- Buscar el contenido de un fichero de una lista de ficheros:
    - Buscar la palabra "password"
    - Buscar un enlace a un fichero mp3
    - Buscar todos los enlaces que haya con imágenes jpg
- Si se encuentra el contenido enviar los ficheros junto con un fichero XML o JSON

- Si un fichero contiene una cadena, crear un XML y un JSON con los datos del fichero
```PowerShell
Get-ChildItem | %{
    if(Get-Content $_ | Select-String 'password')
    {
        "Existe"
        Get-ChildItem $_ | Select-Object -Property Name | Export-Clixml (((Get-Date).Ticks).ToString()+"fichero.xml")
        Get-ChildItem $_ | Select-Object -Property Name | ConvertTo-Json | Out-File fichero.json
    }
}
```

# Solución en PowerShell
```PowerShell
$hash = @{}
$img = 0

Get-Content .\correo.html | %{
    if($_ | Select-String "jpg")
    {
        $img += 1
        $hash.Add("JPG "+$img,$_)
    }
    elseif($_ | Select-String "mp3")
    {
        $hash.Add("MP3",$_)
    }
    elseif($_ | Select-String "textarea")
    {
        $hash.Add("Text",$_ -replace "<.*?>")
    }
}

$object = [PSCustomObject]$hash
$json = $object | Sort-Object Name | ConvertTo-Json
$json
```

# Ayuda para realizar el proyecto

## Leer datos de archivos .PSD1 en PowerShell 5
https://www.jesusninoc.com/12/17/leer-datos-de-archivos-psd1-en-powershell-5/

## Ayuda para generar XML o JSON
```PowerShell
"This is a test" | Export-Clixml sample.xml
Get-ChildItem $_ | Select-Object -Property Name | ConvertTo-Json | Out-File fichero.json
```
### Converting Hash Tables to JSON
https://www.jesusninoc.com/2017/11/18/converting-hash-tables-to-json/

### Importar JSON
https://www.jesusninoc.com/2018/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

### Convertir a JSON el listado de usuarios que hay en el sistema ejecutando un cmdlet con PowerShell
* https://www.jesusninoc.com/2018/02/05/convertir-a-json-el-listado-de-usuarios-que-hay-en-el-sistema-ejecutando-un-cmdlet-con-powershell/

### NMatcher
NMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc). It ports functionality of original php-matcher library to dotnet.
https://github.com/defrag/NMatcher

### PSMatcher
PSMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc).
https://github.com/dfinke/PSMatcher

## Programar tareas
### PowerShell
https://www.jesusninoc.com/2017/03/01/tareas-programadas-en-powershell/
### Linux
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh
* https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1

## SSH
* https://www.jesusninoc.com/2017/09/24/ssh-desde-powershell/
* https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/11/04/descargar-un-fichero-por-ssh-de-un-servidor-linux-desde-powershell-en-windows/

## LOAD XML Syntax (MySQL)
https://www.jesusninoc.com/2014/11/17/load-xml-syntax-mysql/

## HTML Reports
Creating HTML Reports
https://www.jesusninoc.com/2017/10/16/creating-html-reports/

---------------------------------------

# Proyecto: monitorizar el sistema mediante un fichero XML

## Tareas para monitorizar
- Realizar una función de hash sobre varios ficheros
https://www.jesusninoc.com/2018/02/04/realizar-una-funcion-de-hash-sobre-varios-ficheros/
- Si se ha actualizado
	- Finding Computers that haven’t installed a special Hotfix
	https://sid-500.com/2018/02/04/powershell-gathering-information-of-all-installed-updates-hotfixes-on-all-domain-computers/
	- Buscar actualizaciones instaladas con PowerShell
	https://www.jesusninoc.com/2017/09/12/buscar-actualizaciones-instaladas-con-powershell/
- Si programa instalado
- Si fichero permisos
- Si usuario ejecuta proceso
- Crear usuario
- Crear grupo
- Obtener información sobre el hardware
	-Obtener información sobre el hardware creando un objeto con todos los datos
	https://www.jesusninoc.com/2017/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/

## Fichero XML de monitorización
```XML
<?xml version="1.0"?>
<monitorizar>
	<tarea id="1">
		<nombretarea>Si se ha actualizado</nombretarea>
		<tarea>Get-Hotfix | Where-Object HotfixID -eq "KB3186568"</tarea>
	</tarea>
	<tarea id="2">
		<nombretarea>Si programa instalado</nombretarea>
		<tarea>msiexec</tarea>
		<programa>notepad</programa>
	</tarea>
	<tarea id="3">
		<nombretarea>Si fichero permisos</nombretarea>
		<tarea>icacls</tarea>
		<fichero>directorio</fichero>
	</tarea>
	<tarea id="4">
		<nombretarea>Si usuario ejecuta proceso</nombretarea>
		<tarea>Get-WmiObject win32_process |% {Write-Host $_.processname $_.getowner().user}</tarea>
		<proceso>notepad</proceso>
		<usuario>javier</usuario>
	</tarea>
	<tarea id="5">
		<nombretarea>Crear usuario</nombretarea>
		<tarea>New-LocalUser</tarea>
		<usuario>javier</usuario>
	</tarea>
	<tarea id="6">
		<nombretarea>Realizar una funcion de hash sobre varios ficheros</nombretarea>
		<tarea>Get-FileHash ficheromaestro.txt</tarea>
		<usuario>javier</usuario>
	</tarea>
</monitorizar>
```

## Fichero JSON de monitorización
```JSON
{
  "monitorizar": {
    "tarea": [
      {
        "id": "1",
        "nombretarea": "Si se ha actualizado",
        "tarea": "Get-Hotfix"
      },
      {
        "id": "2",
        "nombretarea": "Si programa instalado",
        "tarea": "msiexec",
        "programa": "notepad"
      },
      {
        "id": "3",
        "nombretarea": "Si fichero permisos",
        "tarea": "icacls",
        "fichero": "directorio"
      },
      {
        "id": "4",
        "nombretarea": "Si usuario ejecuta proceso",
        "tarea": "Get-WmiObject win32_process |% {Write-Host $_.processname $_.getowner().user}",
        "proceso": "notepad",
        "usuario": "javier"
      },
      {
        "id": "5",
        "nombretarea": "Crear usuario",
        "tarea": "New-LocalUser",
        "usuario": "javier"
      },
      {
        "id": "6",
        "nombretarea": "Realizar una funcion de hash sobre varios ficheros",
        "tarea": "Get-FileHash ficheromaestro.txt",
        "usuario": "javier"
      }
    ]
  }
}
```

# Solución en PowerShell
```PowerShell
$monitorizar = '{
  "monitorizar": {
    "tarea": [
      {
        "id": "1",
        "nombretarea": "Si se ha actualizado",
        "tarea": "Get-Hotfix"
      },
      {
        "id": "2",
        "nombretarea": "Si programa instalado",
        "tarea": "msiexec",
        "programa": "notepad"
      },
      {
        "id": "3",
        "nombretarea": "Si fichero permisos",
        "tarea": "icacls",
        "fichero": "directorio"
      },
      {
        "id": "4",
        "nombretarea": "Si usuario ejecuta proceso",
        "tarea": "Get-WmiObject win32_process |% {Write-Host $_.processname}"
      }
    ]
  }
}' | ConvertFrom-Json

$monitorizar.monitorizar.tarea | %{
    $_.nombretarea
    $_.tarea | iex
}
```

# Ayuda para realizar el proyecto

## Leer datos de archivos .PSD1 en PowerShell 5
https://www.jesusninoc.com/12/17/leer-datos-de-archivos-psd1-en-powershell-5/

## Ayuda para generar XML o JSON
```PowerShell
"This is a test" | Export-Clixml sample.xml
Get-ChildItem $_ | Select-Object -Property Name | ConvertTo-Json | Out-File fichero.json
```
### Converting Hash Tables to JSON
https://www.jesusninoc.com/2017/11/18/converting-hash-tables-to-json/

### Importar JSON
https://www.jesusninoc.com/2018/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

### Convertir a JSON el listado de usuarios que hay en el sistema ejecutando un cmdlet con PowerShell
* https://www.jesusninoc.com/2018/02/05/convertir-a-json-el-listado-de-usuarios-que-hay-en-el-sistema-ejecutando-un-cmdlet-con-powershell/

### NMatcher
NMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc). It ports functionality of original php-matcher library to dotnet.
https://github.com/defrag/NMatcher

### PSMatcher
PSMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc).
https://github.com/dfinke/PSMatcher

## Programar tareas
### PowerShell
https://www.jesusninoc.com/2017/03/01/tareas-programadas-en-powershell/
### Linux
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh
* https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1

## SSH
* https://www.jesusninoc.com/2017/09/24/ssh-desde-powershell/
* https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/11/04/descargar-un-fichero-por-ssh-de-un-servidor-linux-desde-powershell-en-windows/

## LOAD XML Syntax (MySQL)
https://www.jesusninoc.com/2014/11/17/load-xml-syntax-mysql/

## HTML Reports
Creating HTML Reports
https://www.jesusninoc.com/2017/10/16/creating-html-reports/

---------------------------------------

# Proyecto: crear usuarios mediante un fichero XML

## Fichero XML de usuarios
```XML
<?xml version="1.0"?>
<alumnos>
	<alumno id="1">
		<usuario>juanito</usuario>
		<grupo>ventas</grupo>
		<programa>notepad</programa>
		<directorio>carpetatrabajo</directorio>
		<permisos>leer</permisos>
	</alumno>
	<alumno id="2">
		<usuario>luis</usuario>
		<grupo>ventas</grupo>
		<programa>p7zip</programa>
		<directorio>carpetatrabajo</directorio>
		<permisos>444</permisos>
	</alumno>
</alumnos>
```

## Fichero JSON de usuarios
```JSON
{
  "alumnos": {
    "alumno": [
      {
        "id": "1",
        "usuario": "juanito",
        "grupo": "ventas",
        "programa": "notepad",
        "directorio": "carpetatrabajo",
        "permisos": "leer"
      },
      {
        "id": "2",
        "usuario": "luis",
        "grupo": "ventas",
        "programa": "p7zip",
        "directorio": "carpetatrabajo",
        "permisos": "444"
      }
    ]
  }
}
```

# Ayuda para realizar el proyecto

## Leer datos de archivos .PSD1 en PowerShell 5
https://www.jesusninoc.com/12/17/leer-datos-de-archivos-psd1-en-powershell-5/

## Ayuda para generar XML o JSON
```PowerShell
"This is a test" | Export-Clixml sample.xml
Get-ChildItem $_ | Select-Object -Property Name | ConvertTo-Json | Out-File fichero.json
```
### Converting Hash Tables to JSON
https://www.jesusninoc.com/2017/11/18/converting-hash-tables-to-json/

### Importar JSON
https://www.jesusninoc.com/2018/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

### Convertir a JSON el listado de usuarios que hay en el sistema ejecutando un cmdlet con PowerShell
* https://www.jesusninoc.com/2018/02/05/convertir-a-json-el-listado-de-usuarios-que-hay-en-el-sistema-ejecutando-un-cmdlet-con-powershell/

### NMatcher
NMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc). It ports functionality of original php-matcher library to dotnet.
https://github.com/defrag/NMatcher

### PSMatcher
PSMatcher is a test utility, that lets you easier test responses and json, when some part of the response is something out of your control (autogenerated id, guid, datetime etc).
https://github.com/dfinke/PSMatcher

## Programar tareas
### PowerShell
https://www.jesusninoc.com/2017/03/01/tareas-programadas-en-powershell/
### Linux
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh
* https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1

## SSH
* https://www.jesusninoc.com/2017/09/24/ssh-desde-powershell/
* https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/11/04/descargar-un-fichero-por-ssh-de-un-servidor-linux-desde-powershell-en-windows/

## LOAD XML Syntax (MySQL)
https://www.jesusninoc.com/2014/11/17/load-xml-syntax-mysql/

## HTML Reports
Creating HTML Reports
https://www.jesusninoc.com/2017/10/16/creating-html-reports/
