# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Ejercicios sobre usuarios en PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuarios.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuariosFicheros.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjemplosCrearUsuariosGruposCarpetaCompartida.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjemplosCrearUsuariosGruposCarpetaCompartida2.ps1
* https://www.jesusninoc.com/2012/12/30/add-users-xml/
* https://www.jesusninoc.com/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/

## Más ejercicios sobre usuarios en PowerShell
* https://www.jesusninoc.com/users/

- Ver el SID (Security Identifier) de un usuario en Windows con PowerShell
- Verificar si existe un usuario en Windows 10 con PowerShell
- Obtener los SID de las cuentas de usuario en Windows 10
- Cmdlets relacionados con la gestión de cuentas locales en Windows 10
- Creates a local user account
- Creates a local security group
- Gets local user accounts
- Gets members from a local group
- Gets the local security groups
- Añadir usuarios a un grupo local en Windows 10 con PowerShell 5.1
- Listar miembros de un grupo local en Windows 10 con PowerShell 5.1
- Cambiar la contraseña a un usuario local en Windows 10 con PowerShell 5.1
- Listar grupos locales en Windows 10 con PowerShell 5.1
- Listar usuarios locales en Windows 10 con PowerShell 5.1
- Eliminar un grupo local en Windows 10 con PowerShell 5.1
- Crear un grupo local en Windows 10 con PowerShell 5.1
- Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
- Eliminar un usuario local en Windows 10 con PowerShell 5.1
- Crear un usuario local en Windows 10 con PowerShell 5.1
- Crear un usuario con contraseña leyendo los datos de un fichero
- Cambiar contraseña a un usuario
- Contar el número de grupos que hay en el sistema
- Contar el número de usuarios que hay en el sistema
- List local groups
- List local users
- Añadir un usuario a un grupo
- Crear un grupo
- Crear un usuario con contraseña
- Usuario actual
- Information about group accounts
- Information about user accounts
- Cmdlets relacionados con tareas básicas y de administración en el sistema operativo Windows
- Reading username and password from file and do a login
- Create users and groups, add a user to a group and share directory
- Create users with passwords
- Information about remote user
