# Examen 1ª recuperación
## Realizar el siguiente script mediante funciones:
1.	Crear carpetas para cada servicio.
2.	Añadir a cada carpeta información sobre los procesos que están relacionados con cada servicio.
3.	Añadir a cada carpeta información sobre los hilos y los procesos que están relacionados cada servicio.
------------------------
# Instalación de software

## Linux
### Instalación con dpkg y apt-get
```Bash
dpkg
apt-get
```
### Instalar con aptitude
```Bash
aptitude update && aptitude install -y a b c d e
```
### Script para instalar leyendo de fichero (Debian y Fedora)
Realizar un script que lea de un fichero nombres de aplicaciones que se tienen que instalar en Debian y Fedora
```bash
while read linea
do
   apt-get install linea
done < archivo
```

## Windows
### Instalar en PowerShell 5
* https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
### Instalar remotamente un paquete MSI
* https://www.jesusninoc.com/2017/05/27/instalar-remotamente-un-paquete-msi/

# Listado de software (ejercicios con sobre el software instalado)

## Linux
```bash
apt list --installed
```
### Aplicaciones instaladas
* https://github.com/jesusninoc/Bash/blob/master/Programas/EjerciciosProgramas.sh

## Windows
* https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/

## macOS
```bash
ls -la /Applications/
sudo find / -iname '*.app'
```

# Script que instala en Windows y Linux
## Instalar software en cualquier equipo de la red desde PowerShell leyendo desde un archivo la información para instalar utilizando credenciales almacenados (solución de Diego A.)

```powershell
#Estructura para lista.txt:
#[NOMBRE-PAQUETE] [IP-HOST / THISPC] [ACTION (INSTALL / UNINSTALL)]
#skype 192.168.1.161 install

#Para crear credenciales: 
#read-host -AsSecureString | ConvertFrom-SecureString
#El resultado meterlo en archivo cred:
#[IP] [USUARIO] [CREDENCIAL]

gc ./lista.txt | % {
    $package = $_.split(' ')[0]
    $hostp = $_.split(' ')[1]
    $action = $_.split(' ')[2]
    
    if($hostp -eq 'thispc'){
        if($action -eq 'install'){
            Install-Package -name $package
        }elseif($action -eq 'uninstall'){
            Uninstall-Package -name $package
        }
    }else{
        gc .\cred | % {
            if($_.split(' ')[0] -eq $hostp){
                $user = $_.split(' ')[1]
                echo $_.split(' ')[2]
                $pass = $_.split(' ')[2] | ConvertTo-SecureString
                $credentials = new-object -typename System.Management.Automation.PSCredential -argumentlist $user,$pass

                #New-SSHSession -ComputerName $hostp -Credential (Get-Credential)
                New-SSHSession -ComputerName $hostp -Credential $credentials
                if($action -eq 'install'){
                    (Invoke-SSHCommand -Index 0 -Command 'apt-get install '+$package+' -y').Output
                }elseif($action -eq 'uninstall'){
                    (Invoke-SSHCommand -Index 0 -Command 'apt-get remove '+$package+' -y').Output
                }
                
                Remove-SSHSession -SessionId 0
            }
        }
    }
}
```
