# Examen de la primera evaluación

## Crear carpetas para cada extensión
```PowerShell
# Crear carpetas para cada extensión.

function extensiones
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    $ruta
  )

  begin
  {
    Write-Host "Begin de extensión"
    $var = ls $ruta | select Extension
  }

  process
  {
    $var | %{
        mkdir $_.Extension
    }
  }
  end
  {
    Write-Host "Final de extensión"
    Get-ChildItem
  }
}

extensiones ../
```
## Carpeta txt y dentro de la carpeta copiar ficheros con extensión txt
```PowerShell
function txt
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    $ruta
  )

  begin
  {
    Write-Host "Begin de txt"
    mkdir txt
  }

  process
  {
    Copy-Item -Path $ruta -Destination txt -Force -WhatIf
  }
  end
  {
    Write-Host "Final de txt"
    Get-ChildItem
  }
}

txt ../*.txt
```
## Realiza una función de login que almacene los intentos fallidos y correctos
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

## Mostrar los servicios que representan comportamientos extraños
* https://www.jesusninoc.com/11/10/analizar-servicios-con-powershell/
