# Examen liberatorio II

- Realizar una función de muestre el consumo de procesador analizando dos valores (consumo -cpu 20 -id 6000).

```PowerShell
# Sirve para ir de uno en uno
(Get-Process | select $proceso).cpu -gt $valor

# Varios valores
Get-Process | Where-Object cpu -gt 10 | Where-Object id -gt 6000
```



- Realizar una función que permita detectar que hay una firma que ha cambiado en un programa.
```PowerShell
# Función simple para almacenar un hash de un programa
function hashear($ruta){
    Get-FileHash $ruta
}

(hashear 'C:\Windows\System32\notepad.exe' | select hash).hash | Out-File hash.txt

(gc hash.txt)

Get-Process | select Path | %{
    hashear $_.Path
}

Get-Process | select Path | %{
    (hashear $_.Path).hash
}

Get-Process | select Path | %{
    if ((hashear $_.Path).hash -match (gc hash.txt))
    {
        "Igual",$_.path
    }
}
```
- Realizar una función que muestre información sobre los hilos de un proceso.
```PowerShell
function hilos($name){
    $processHandle = (Get-Process -Name $name).id
    $Threads = Get-WmiObject -Class Win32_Thread |
    Where-Object { $_.ProcessHandle -eq $processHandle }
    "The $name process has $($threads.count) threads"
    $threads | Format-Table -Property priority, thread*, User*Time, kernel*Time
}

hilos notepad
```
- Realizar una función que muestre los procesos que utilizan un controlador.
```PowerShell
Get-Process -Module | select-string "OLEAUT32.dll"

Get-Process -Module | %{
    $_ | select-string "OLEAUT32.dll"
}

Get-Process | select name,Modules  | %{
    $_.name
    $_.Modules.ModuleName | select-string "OLEAUT32.dll"
}

Get-Process | select name,Modules | %{
    if($_.Modules.ModuleName -eq "OLEAUT32.dll")
    {
        $_.Name,$_.Modules.ModuleName
    }
}
```
