## Ejercicios de PowerShell: dividir el contenido de una frase en palabras y guardar cada palabra en un fichero
* https://www.youtube.com/watch?v=5bw3hpmk9-Q
* https://www.jesusninoc.com/2016/12/07/ejercicios-de-powershell-dividir-el-contenido-de-una-frase-en-palabras-y-guardar-cada-palabra-en-un-fichero/
* https://www.jesusninoc.com/11/27/tendencias-actuales-en-el-buscador-de-google-con-powershell/
### Almacenar el número de veces que aparece una palabra
```PowerShell
"En cierto lugar en".Split(" ") | Group-Object | %{ni -Path $_.name[0] -Name $_.name -value $_.Count -force}
```

# Introducción a las funciones
* https://www.youtube.com/watch?v=hBm1U8ft6NA
* https://github.com/jesnino/PowerShell/tree/master/Funciones
* https://github.com/jesnino/PowerShell/blob/master/Funciones/EjemplosFuncionesAvanzadasLogin.ps1
* https://github.com/jesnino/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesnino/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1
* https://github.com/jesnino/PowerShell/blob/master/Funciones/EjerciciosFuncionesLogin.ps1

## Ejemplos sobre funciones con y sin parámetros
### Realizar una suma con parámetros
```PowerShell
function sumarp($parametro1, $parametro2)
{
return $parametro1+$parametro2
}
#Ejecutar la función:
sumarp 5 4
```
### Realizar una suma con parámetros
```PowerShell
function sumar
{
$args[0]+$args[1]
}
#Ejecutar la función:
sumar 5 4
```

## Ejercicios sobre funciones
### Introducir pass y ver si es correcto
```PowerShell
function validacion($parametro1, $parametro2){
$user=$parametro1
$pass=$parametro2
if($user -eq "pepito" -and $pass -eq "secreto")
{
Write-Host $user "validado correctamente"
}
}
validacion pepito sec
validacion pepito secreto
```
### Introducir pass y ver si es correcto (dos pasos)
```PowerShell
function validacion(){
$user=Read-Host
$pass=Read-Host
if($user -eq "pepito" -and $pass -eq "secreto" -and (gc q:\fich.txt) -eq 1234)
{
Write-Host $user
}
}

validacion
```

# Habilitar la autenticación en dos pasos para SSH con Google Authenticator
https://www.entredevyops.es/posts/ssh-2fa.html
