# Examen liberatorio
- Las preguntas que implican respuestas por scripts se pueden hacer en PowerShell o Linux (o en los dos a la vez).
- Utiliza bucles, condiciones, ficheros, funciones, etc.
 
## 1. Realizar un inventario de tu equipo a nivel hardware y software, ten en cuenta cómo clasificar la información y no olvides temas importantes como por ejemplo controladores.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-12.md
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware2.ps1

```PowerShell
#Llamadas WMI
$ComputerSystem=Get-WmiObject Win32_ComputerSystem
$BaseBoard=Get-WmiObject Win32_BaseBoard
$BIOS=Get-WmiObject Win32_BIOS
$Processor=Get-WmiObject Win32_Processor
$Battery=Get-WmiObject Win32_Battery
$programas=Get-Package
$controladores=Get-Process -Module
 
#Crear un objeto con todos los datos sobre el hardware
$equipo=[PSCustomObject]@{
 Model = $ComputerSystem.Model
 ManufacturerBoard = $BaseBoard.Manufacturer
 BIOSVersion = $BIOS.SMbiosbiosversion
 BIOSSerialNumber = $BIOS.serialnumber
 ManufacturerProcessor=$Processor.Manufacturer
 MaxClockSpeed=$Processor.MaxClockSpeed
 Cargadelprcesador=$Processor.LoadPercentage
 programas=$programas.name
 conontroladores=$controladores
}

$equipo.programas
$equipo.conontroladores
```

## 2. Crear una estructura de ficheros en Linux y establece permisos, los permisos tienen que estar establecidos con el mayor criterio posible.
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjercicioPermisos.sh

## 3. Explicar todo lo que sepas sobre virtualización y qué relación tiene con las clases de los jueves.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-30.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-23.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-16.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-09.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-02.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-26.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-19.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-28.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-21.md

## 4. Analizar tu equipo desde el punto de vista de los programas, procesos, servicios e hilos.
https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/

## 5. Monitorizar un valor de tu equipo.
https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosFuncionesProcesos2.ps1
```PowerShell
Get-Process | Where-Object PM -GT 50MB
Get-Process | Where-Object CPU -GT 1 | Where-Object PM -GT 50MB
```

## 6. Realizar un login implementando autenticación de segundo factor y almacena los intentos de login fallido.
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

```PowerShell
#Login de user y pass
#El user y pass correcto se escriben en el bloque BEGIN

function login0
{
  param([Parameter(Mandatory=$true, ValueFromPipeline=$true)][String[]][AllowEmptyString()]$User,$Pass,$Pass2)

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="jaime"
    $passcorrecto="hola"
    $passcorrecto2=gc .\pin.txt
  }

  process
  {
   if($User -eq $usercorrecto -and $Pass -eq $passcorrecto -and $Pass2 -eq $passcorrecto2)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
        $User,$Pass,$Pass2 | Out-File log.txt -Append
    }
    Write-Host "Fin de login"
  }
}

#Ejecutar la función: login0
login0 -User jaime -Pass hola -Pass2 1234
```
