# Permisos especiales en Linux
http://rm-rf.es/permisos-especiales-setuid-setgid-sticky-bit/

|Permiso|Explicación
|---|---
|- - - - - - - - -	= 0|Predeterminado, sin permisos especiales. No se requiere indicar.
|- - - - - - - - t	= 1|Bit de persistencia, sticky bit
|- - - - - s - - -	= 2|Bit sgid de grupo
|- - - - - s - - t	= 3|Bit sgid y sticky
|- - s - - - - - -	= 4|Bit suid
|- - s - - - - - t	= 5|Bit suid y sticky
|- - s - - s - - -	= 6|Bit suid y sgid
|- - s - - s - - t	= 7|Bit suid, sgid y sticky

- sticky: se utiliza para permitir que cualquiera pueda escribir y modificar sobre un archivo o directorio, pero que solo su propietario o root pueda eliminarlo. 
- suid: el bit SUID activo en un archivo significa que el que lo ejecute va a tener los mismos permisos que el que creó el archivo.
- sgid: el SGID es lo mismo que en el SUID, pero a nivel de grupo. Es decir, todo archivo que tenga activo el SGID, al ser ejecutado, tendrá los privilegios del grupo al que pertenece.

# Linux permisos
* https://www.jesusninoc.com/2018/03/09/learn-linux-file-permissions-i/
* https://www.jesusninoc.com/2018/03/11/learn-linux-file-permissions-ii/

## Uso de &&

### Crear fichero pero leyendo cada parte utilizando awk (TODO JUNTO) con echo
```Bash
`echo "touch amigo" | awk '{print $1}' && echo "touch amigo" | awk '{print $2}'`
```

### Crear fichero pero leyendo cada parte utilizando awk (TODO JUNTO) con echo
```Bash
`cat operaciones  | awk '{print $1}' && cat operaciones | awk '{print $2}'`
```

# Ejercicio de login
```PowerShell
#Login de user y pass
#El user y pass correcto se escriben en el bloque BEGIN
#Ejecutar la función: login0
login0 -User jaime -Pass hola

function login0
{
  param([Parameter(Mandatory=$true, ValueFromPipeline=$true)][String[]][AllowEmptyString()]$User,$Pass)

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="user"
    $passcorrecto="pass"
  }

  process
  {
   if($User -eq $usercorrecto -and $Pass -eq $passcorrecto)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
        $User,$Pass | Out-File log.txt -Append
    }
    Write-Host "Fin de login"
  }
}
```

# POWERSHELL + LINUX
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'for (( i=1; i <= 10; i++ )); do echo "Number $i"; done'
$resultado.Output
```

# ENLACES INTERESANTES:

- NC
http://www.thegeekstuff.com/2012/04/nc-command-examples/?utm_source=feedburner

- SUBIR FICHEROS AL SERVIDOR SSH
https://www.jesusninoc.com/2017/10/27/crear-y-ejecutar-un-script-de-powershell-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/

- SUBIR UN FICHERO POR SCP
https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/

- REDIRECCIÓN
https://www.jesusninoc.com/2016/11/02/realizar-una-redireccion-con-javascript-utilizando-start-process-y-google-chrome/

# Crear un audio que vamos a mandar mediante señales de radio

```PowerShell
#Convertir una frase en audio con la voz del sistema operativo desde PowerShell

Add-Type -AssemblyName System.Speech
$synthesizer = New-Object -TypeName System.Speech.Synthesis.SpeechSynthesizer
$synthesizer.SetOutputToWaveFile("saludo.wav")
$synthesizer.Speak("Hola amigo Pedro")
$synthesizer.SetOutputToDefaultAudioDevice()
Get-ChildItem .\saludo.wav
```

# Subir el audio a Raspberry Pi realizando una conexión SCP
```PowerShell
#Iniciar una sesión SCP
#Para iniciar sesión SSH es necesario indicar la dirección IP del equipo al que nos vamos a conectar y también hay que introducir los credenciales (usuario y contraseña).

$Pass = ConvertTo-SecureString -String "raspberry" -AsPlainText -Force
$Credential = New-Object -TypeName "System.Management.Automation.PSCredential" -ArgumentList "pi", $Pass

#Para configurar Set-SCPFile
#Indicar el fichero que vamos a subir -LocalFile
#Indicar el equipo al que nos vamos a conectar -ComputerName
#Indicar la ruta en la que vamos a subir el audio -RemotePath
#Forzar la conexión para evitar fallo "Key exchange negotiation failed."
#Indicar los credenciales que hemos creado anteriormente

Set-SCPFile -LocalFile .\saludo.wav -ComputerName 192.168.1.161 -RemotePath ./fmm/fm_transmitter-master -Force -Credential $Credential
```
