# Crear un contenedor Docker con un servidor de streaming
https://www.jesusninoc.com/11/08/crear-un-contenedor-docker-con-un-servidor-de-streaming/
# Cortar un vídeo
https://github.com/jesusninoc/Scripts/blob/master/Cortar%20un%20v%C3%ADdeo.sh
# Dejavu: audio fingerprinting and recognition in Python
https://www.jesusninoc.com/02/06/dejavu-audio-fingerprinting-and-recognition-in-python/

# Ejercicios sobre copias de seguridad

- Copia de seguridad para cada día de la semana y ser capaz de recuperar
- Comprimir las copias de seguridad que se han realizado
- Enviar un mail cuando se haya realizado la copia de seguridad

```PowerShell
mkdir (Get-Date).ToString("yyyyMMdd")
cd (Get-Date).ToString("yyyyMMdd")
Get-ChildItem ../ *.txt | Copy-Item

Get-ChildItem | select LastWriteTime
Get-ChildItem ../  | where LastWriteTime -gt (Get-Date).AddDays(-1) | Copy-Item

# Restaurar
mkdir tuscosasperdidas
cd .\tuscosasperdidas
Get-ChildItem ../ | Copy-Item

# Restaurar en función de lo que pide el usuario
$datosusar = Read-Host "Dime el nombre del arhcivo que tengo que recuperar"
ls $datosusar* | Copy-Item

# Comprimir el directorio con la fecha
$fecha = (Get-Date).ToString("yyyyMMdd") + ".zip"
Compress-Archive -LiteralPath .\20181119 –CompressionLevel Optimal -DestinationPath $fecha

Compress-Archive -LiteralPath virus.exe -Update -DestinationPath $fecha
```

# Ayuda para copia de seguridad
## MySQL dump ignorando tablas
https://github.com/jesusninoc/Scripts/blob/master/MySQL%20dump%20ignorando%20tablas.sh
## MySQL dump completo
https://github.com/jesusninoc/Scripts/blob/master/MySQL%20dump%20completo.sh
## Comprimir y descomprimir
```PowerShell
Compress-Archive -LiteralPath C:\powershell\example.txt –CompressionLevel Optimal -DestinationPath C:\powershell\comprimido.zip
Expand-Archive -LiteralPath C:\powershell\comprimido.zip -DestinationPath C:\powershell\descomprimir
Compress-Archive -LiteralPath C:\powershell\example2.txt -Update -DestinationPath C:\powershell\comprimido.zip
```
