# Administración y aseguramiento de la información:
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
    
# PowerShell
## 10. Gestión del rendimiento en PowerShell para administradores de sistemas (nivel básico)
https://www.jesusninoc.com/11/16/10-gestion-del-rendimiento-en-powershell-para-administradores-de-sistemas/

## Borrar copias de seguridad de bases de datos en MySQL.sh
https://github.com/jesusninoc/Scripts/blob/master/Borrar%20copias%20de%20seguridad%20de%20bases%20de%20datos%20en%20MySQL.sh

## Database Backup Program (examples)
https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/

# Repaso procesos y servicios
## INFORMACIÓN AVANZADA DE PROCESOS
https://github.com/jesnino/Bash/blob/master/Procesos/EjerciciosProcesos.sh

## Crear servicios
https://www.jesusninoc.com/2017/10/17/crear-un-servicio-en-windows-con-powershell/

```PowerShell
New-Service -Name "Tes2" -BinaryPathName '"C:\Program Files\MySQL\MySQL Server 5.1\bin\mysqld" --defaults-file="C:\Program Files\MySQL\MySQL Server 5.1\my.ini" MySQL'

Start-Service tes2
Stop-Service tes2
```

## Cómo matar procesos
### Matar el proceso sacando el ID del proceso
```Bash
kill -9 `pidof apache2`
```

# Permisos en PowerShell
https://www.jesusninoc.com/2016/09/10/obtener-los-descriptores-de-seguridad-de-todos-los-ficheros-de-una-unidad/
