# Administración y aseguramiento de la información:
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

# Netcat
* https://www.jesusninoc.com/11/12/enviar-un-video-mp4-entre-dos-linux-mediante-netcat/

# Crear un contenedor Docker con un servidor de streaming
https://www.jesusninoc.com/11/08/crear-un-contenedor-docker-con-un-servidor-de-streaming/

# Servidor Linux en OVH

# Mediante la utilización de funciones en PowerShell resolver las siguientes situaciones:
- Mostrar todos los procesos.
- Mostrar los X primeros procesos.
- Mostrar los X últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Mostrar los X procesos cuyo consumo (el parámetro que quieras utilizar) sea mayor que el valor que quieras monitorizar.
- Agrupar los procesos y muestra los que sean XXXXX.

## Función para mostrar todos los procesos
```PowerShell
function Procesos
{
Get-Process
}
Procesos
```

## Función para mostrar los X primeros procesos
```PowerShell
function ProcesosPrimeros($numero)
{
Get-Process | Select-Object -First $numero
}
ProcesosPrimeros 5
```

## Función para mostrar los X primeros procesos utilizando Mandatory
```PowerShell
function ProcesosUltimosM
{
param
(
[Parameter(Mandatory=$true)]
$numero
)
Get-Process | Select-Object -Last $numero
}
ProcesosUltimosM 5
```

## Función para mostrar los X últimos procesos
```PowerShell
function ProcesosUltimos($numero)
{
Get-Process | Select-Object -Last $numero
}
ProcesosUltimos 5
```

## Función para ordenar todos los procesos por CPU de forma descendente
```PowerShell
function ProcesosCPU
{
Get-Process | Sort-Object CPU -Descending
}
ProcesosCPU
```

## Función para mostrar los X procesos cuyo consumo (el parámetro que quieras utilizar) sea mayor que el valor que quieras monitorizar
```PowerShell
function ProcesosConsumo([String]$parametro,[Int]$valor,[Int]$numerovalores)
{
$parametro
$valor
$numerovalores
Get-Process | Where-Object $parametro -GT $valor | Select-Object -First $numerovalores
}
ProcesosConsumo CPU 30 5
```

## Función para agrupa los procesos y muestra los que sean XXXXX
```PowerShell
function ProcesoConcreto($nombreproceso)
{
Get-Process -Name $nombreproceso | Group-Object
}
ProcesoConcreto svchost
```

## Abrir una página web las veces que quiera el usuario
```PowerShell
function abrirweb ($numero,$url)
{
    1..$numero | %{
        start $url
        [System.Console]::Beep(261,500)
    }
}

abrirweb 3 http://www.jesusninoc.com
```
## Enviar un mail al responsables de la recuperación con PowerShell
https://www.jesusninoc.com/04/11/enviar-un-mail-desde-powershell/

```PowerShell
```
