# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.

# Ejercicios

## Crear cinco directorios y dentro de cada directorio crear 10 ficheros
```PowerShell
foreach($directorio in 1..5)
{
    New-Item -Name $directorio -WhatIf -ItemType Directory
    foreach($fichero in 1..10)
    {
        New-Item -Path $directorio -Name $fichero -WhatIf -ItemType File 
    }
}
```

# Permissions
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask
