# Soluciones examen

## Alias de cmdlet y comandos de Linux
|Cmdlets PowerShell|Linux
|---|---
|Get-Location|pwd
|Set-Location|cd
|Read-Host|read
|Write-Host|echo
|Get-Process|ps

## Listar procesos y guardar en fichero
```PowerShell
Get-Process | Out-File procesos.txt -Append
```

## Listar proceso que indica el usuario y guardar información en fichero
```PowerShell
Get-Process -Name (Read-Host) | Out-File procesos.txt -Append
```

## ASCII
```PowerShell
0..127 | %{[Char]$_}
```

## El usuario indica cuántos niveles subir
```PowerShell
Set-Location ("../"*(Read-Host))
```

# Procesador enlaces
## (Apartado procesador)
https://www.jesusninoc.com/2017/07/03/3-gestion-del-hardware-en-powershell/
## (Apartado de procesador)
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

# Procesos enlace
https://www.jesusninoc.com/2015/02/03/mostrar-informacion-sobre-procesos-en-linux-y-windows/

# Where en PowerShell
```PowerShell
Get-Process | Where-Object name -EQ "notepad"
```

# Split en PowerShell
```PowerShell
"hola@adios" -split "@"
("hola@adios" -split "@")[0]
("hola@adios" -split "@")[1]
"hola@adios#" -replace "#","@" -split "@"
```

# DIBUJO DE ESQUEMA EJEMPLO EN LINUX
* https://pbs.twimg.com/media/CdtD3yrUYAAYL2_.png:large
* http://www.brendangregg.com/linuxperf.html
* http://www.brendangregg.com/Perf/linux_perf_tools_full.png
* https://www.tecmint.com/command-line-tools-to-monitor-linux-performance/

# Morse windows y linux
* http://www.openrobots.org/morse/doc/1.2/user/installation.html
* https://www.jesusninoc.com/2017/01/04/detectar-un-mensaje-enviado-en-codigo-morse-mediante-sonidos-utilizando-la-tarjeta-de-sonido-y-el-programa-sdrsharp/
* http://www.blackcatsystems.com/software/morse-code-practice-software.html
* https://www.howtoinstall.co/es/ubuntu/xenial/morse

# Conexión con:
## PARA LINUX
https://www.jesusninoc.com/2015/02/03/mostrar-informacion-sobre-procesos-en-linux-y-windows/

## BUCLE LINUX Y POWERSHELL
* https://www.jesusninoc.com/2017/10/08/listar-todos-los-caracteres-ascii-en-powershell/
* https://www.jesusninoc.com/2017/10/05/listar-todos-los-caracteres-ascii-en-bash/

## POWERSHELL + LINUX
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'for (( i=1; i <= 10; i++ )); do echo "Number $i"; done'
$resultado.Output
```
# USO DE ADB
https://www.jesusninoc.com/2016/10/30/abrir-whatsapp-mediante-adb-a-traves-de-powershell/

## Realizar varias búsquedas con Google Chrome en Android leyendo de un fichero y pulsar en un enlace mediante un script en la shell de Android con ADB
https://www.jesusninoc.com/2016/04/10/realizar-varias-busquedas-con-google-chrome-en-android-leyendo-de-un-fichero-y-pulsar-en-un-enlace-mediante-adb-a-traves-de-powershell/
