# Linux

## Variables
https://www.jesusninoc.com/2015/01/04/curso-de-bash-scripting-con-ejemplos/

### Variables 1: enteros, caracteres y cadenas de caracteres
https://www.jesusninoc.com/2014/10/28/variables-1-enteros-caracteres-y-cadenas-de-caracteres/
### Variables 2: concatenar, extraer, medir cadenas
https://www.jesusninoc.com/2014/10/24/variables-2-concatenar-extraer-elementos-y-medir-la-longitud-de-un-array/
### Variables 3: almacenar la ejecución de un comando
https://www.jesusninoc.com/2014/10/23/variables-3-almacenar-la-ejecucion-de-un-comando/
### Variables 4: almacenar en fichero
https://www.jesusninoc.com/2014/10/22/variables-4-almacenar-en-fichero/
### Variables 5: leer de un fichero
https://www.jesusninoc.com/2014/10/21/variables-5-leer-de-un-fichero/
### Variables 6: etiquetas HTML
https://www.jesusninoc.com/2014/10/20/variables-6-etiquetas-html/
### Variables 7: ordenar y eliminar elementos duplicados
https://www.jesusninoc.com/2014/10/19/variables-7-ordenar-y-eliminar-elementos-duplicados-2/
### Variables 8: eliminar caracteres en blanco
https://www.jesusninoc.com/2014/10/18/variables-8-eliminar-caracteres-en-blanco/

## Bucle
Example C for loop syntax
```Bash
for (( i=1; i <= 10; i++ ))
do
echo "Number $i"
done
```

## Ejercicio: ejecutar el comando almacenado en un fichero
* https://github.com/jesusninoc/Bash/blob/master/Introduccion/EjemplosIntroducci%C3%B3n.sh

```Bash
echo "ps" > fichero
echo "ls" >> fichero
`cat fichero | head -n 1`
```

```Bash
echo "ps" > fichero
echo "ls" >> fichero

while read linea
do
echo $linea
`echo $linea` >> resultado
done < fichero

cat resultado
```

# PowerShell
## Ejercicio: convertir el ejercico de Bash en PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Bucles/RepasoBucleForEach.ps1

# Importante

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## Instalar y ejecutar SSH para PowerShell
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.11 -Credential (Get-Credential)
```

## SSH sobre PowerShell
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```


