# Instalación de software libre y propietario

- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
- Ficheros necesarios para el arranque de los principales sistemas operativos.
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.
- Actualización y mantenimiento de controladores de dispositivos.
  - Automatizar la actualización de controladores.
  - Volver a una versión anterior de un controlador.
  - Actualización manual de los controladores.

# Instalar con PowerShell
https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/
```PowerShell
Install-Package -provider chocolatey -name zoomit
```

# Actualizar en Windows
* https://docs.microsoft.com/en-us/windows/desktop/msi/command-line-options
* https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/

# Instalar en Bash
* https://help.ubuntu.com/community/AptGet/Howto

# Actualizar en Linux
### This command upgrades all installed packages. This is the equivalent of "Mark all upgrades" in Synaptic.
```Bash
apt-get update & apt-get upgrade
```
### Setting up apt-get to use a http-proxy
```Bash
export http_proxy=http://yourproxyaddress:proxyport
```

# Ejecutar comandos
## Bash
```Bash
echo ps
echo 'ps'
echo `ps`
```
## PowerShell
```PowerShell
$hola="Get-Process -Name notepad"
Invoke-Expression ($hola)
```

# Mezcla de comandos entre PowerShell y Bash
```PowerShell
for($i=1;$i -le 5;$i=$i+1)
{
    $multi=($i*100) 
    $nombre="fichero$i"
    $resultado=Invoke-SSHCommand -Index 0 ('echo' + $multi + ' >' + $nombre)
    $resultado.Output 
}
```
