# Mostrar la relación entre servicios y procesos con PowerShell
```PowerShell
Get-WmiObject -Class Win32_Service | Select-Object Name,@{Name="ProcessID";Expression={$_.ProcessID;(Get-Process -Id $_.ProcessID).name}}
```

# Obtener información sobre la memoria en PowerShell
## Cmdlets
```PowerShell
Get-WmiObject Win32_MemoryArray
Get-WmiObject Win32_MemoryArrayLocation
Get-WmiObject Win32_MemoryDevice
Get-WmiObject Win32_MemoryDeviceArray
Get-WmiObject Win32_MemoryDeviceLocation
Get-WmiObject Win32_PhysicalMemory
Get-WmiObject Win32_PhysicalMemoryArray
Get-WmiObject Win32_PhysicalMemoryLocation
Get-WmiObject Win32_SMBIOSMemory
```
## Ejercicios
### Saber si el fabricante de la memoria es Elpida, Kingston o Hynix
```PowerShell
if((Get-WmiObject Win32_PhysicalMemory).Manufacturer -match "Elpida"){"Elpida"}else{"No es Elpida"}
```
## Volcado de memoria
https://isc.sans.edu/diary.html?date=2016-09-27

# Obtener información sobre caché en PowerShell
## Cmdlets
```PowerShell
Get-WmiObject Win32_AssociatedProcessorMemory
Get-WmiObject Win32_CacheMemory
```

# Ejercicios
- Guardar en un fichero información sobre el hardware del equipo
- Ver la utilización del procesador y compararlo con el consumo de CPU de los procesos
- Contar el número de procesos que se están ejecutando
- Seleccionar los 5 procesos que más consumen
- Los 5 que menos consumen
- Buscar un proceso que se ejecuta: (Get-Process).Where{$_.Name -like "chrome"}
- Listar los procesos que tengan consumo alto de tiempo de CPU

# Parte especial de la clase (conexión con Linux)

## Instalar Apache
https://www.digitalocean.com/community/tutorials/how-to-install-the-apache-web-server-on-ubuntu-16-04

## Guardar un fichero html preguntando al usuario qué título quiere
```PowerShell
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html
start chrome .\web.html
```
## Configurar IP en Windows
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

# SSH

## Instalar y ejecutar SSH para PowerShell
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.11 -Credential (Get-Credential)
```

## Ejemplo: obtener información sobre la versión de Linux
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.14 -Credential (Get-Credential)
Get-SSHSession
Invoke-SSHCommand -Index 0 "uname"
```

# WSL
## Obtener información sobre la versión de Linux con WSL
```PowerShell
wsl uname -r
wsl uname -a
wsl cat /proc/version
```

## Información sobre la arquitectura
```PowerShell
(Invoke-SSHCommand -Index 0 "bash -c ""lscpu | grep 'Architecture'""").output
```

## 3. Gestión del hardware en Linux (nivel intermedio)
https://www.jesusninoc.com/03/03/3-gestion-del-hardware-en-linux-nivel-intermedio/
