# PowerShell

## Ayuda ejercicio
### Crear varios discos virtuales leyendo desde un fichero la información (nombre y tamaño), los discos hay que particionarlos y formatearlos.
* https://madoti.wordpress.com/2017/12/01/crear-un-disco-virtual-con-windows-powershell/

## Bucle

### Bucle foreach PowerShell
https://www.jesusninoc.com/2015/09/29/bucles/

### Ejemplos bucle
```PowerShell
for($i=1;$i -lt 10;$i=$i+1){$i}
for($i=10;$i -gt 0;$i=$i-1){$i}
```

## Operadores de comparación
If you are used to operators such as > or < or =, you have to do some rethinking. As with batch scripts, PowerShell uses abbreviations of the corresponding English words.

|Op|Description
|---|---
|eq|Equal
|ne|Not equal
|lt|Less than
|le|Less than or equal
|gt|Greater than
|ge|Greater than or equal

# Linux

## Variables
https://www.jesusninoc.com/2015/01/04/curso-de-bash-scripting-con-ejemplos/

### Variables 1: enteros, caracteres y cadenas de caracteres
https://www.jesusninoc.com/2014/10/28/variables-1-enteros-caracteres-y-cadenas-de-caracteres/
### Variables 2: concatenar, extraer, medir cadenas
https://www.jesusninoc.com/2014/10/24/variables-2-concatenar-extraer-elementos-y-medir-la-longitud-de-un-array/
### Variables 3: almacenar la ejecución de un comando
https://www.jesusninoc.com/2014/10/23/variables-3-almacenar-la-ejecucion-de-un-comando/

# Importante

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## Instalar y ejecutar SSH para PowerShell
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.11 -Credential (Get-Credential)
```

## SSH sobre PowerShell
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```


