# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Saber traducir lo básico entre Linux y PowerShell
https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-02.md
# Examen
https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-03.md

# Servicios
```PowerShell
Get-WmiObject -Class Win32_Service | Select-Object Name,ProcessID, (Get-Process -Id ProcessID).name
```

```PowerShell
Get-WmiObject -Class Win32_Service | %{
Write-Host $_.Name,$_.ProcessID,(Get-Process -Id $_.ProcessID).name
}
```

# Procesos y ruta de ejecución del proceso
```PowerShell
Get-WmiObject -Class win32_process | select Path,ExecutablePath, CommandLine | Format-Custom
```

# Ejercicio sencillo (la semana que viene será avanzado)
## Explica el apartado de funciones del sistema operativo en relación con los cmdlets de PowerShell que conoces, ayuda:
- Gestión de procesos.
- Gestión de memoria.
- Gestión de archivos.
- Gestión de elementos de E/S.

# Parte especial de la clase (conexión con Linux)

## Guardar un fichero html preguntando al usuario qué título quiere
```PowerShell
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html
start chrome .\web.html
```
## Configurar IP en Windows
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

# SSH

## Instalar y ejecutar SSH para PowerShell
```PowerShell
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
New-SSHSession -ComputerName 10.0.2.11 -Credential (Get-Credential)
```

## Ejemplo para SSH
https://www.jesusninoc.com/2017/09/24/ssh-desde-powershell/

## Conectar con Linux por SSH
https://www.jesusninoc.com/2017/09/26/ejecutar-un-script-de-powershell-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/
