# Instalación de software libre y propietario

- Tipos de sistemas operativos.
  - Monousuario o multiusuario
  - Centralizado o distribuido
  - Monotarea o multitarea
  - Uniprocesador o multiprocesador
  - Instalables y/o autoarrancables.
- Sistemas operativos libres.
- Sistemas operativos propietarios.
- Tipos de aplicaciones. Software de sistema. Software de programación. Software de aplicación.
- Licencias y tipos de licencias. Según los derechos que cada autor se reserva sobre su obra. Según su destinatario.

# Ejercicios PowerShell hilos y procesos

```PowerShell
Get-Process | select *
Get-Process | select Threads
Get-Process | select Threads | Format-Custom
(Get-Process | select Threads).count
Get-WmiObject -Class Win32_Thread
Get-WmiObject -Class Win32_Thread  | Format-Table -Property priority, thread*, User*Time, kernel*Time 
(Get-WmiObject -Class Win32_Thread).count
(Get-WmiObject -Class Win32_Thread  | Format-Table -Property priority, thread*, User*Time, kernel*Time).count
```

```PowerShell
Get-WmiObject -Class Win32_Thread
Get-WmiObject -Class Win32_Process
```

```PowerShell
Get-Process | select id,threads
Get-WmiObject win32_process | Select-Object ParentProcessId,ProcessId
```
# Ejemplos sobre hilos

```PowerShell
Get-Process | select Name,Threads | Out-GridView

(Get-WmiObject -Class Win32_Thread  | Format-Table -Property priority, thread*, User*Time, kernel*Time ).count
(Get-WmiObject -Class Win32_Thread).count

Get-WmiObject -Class Win32_Thread | select id,priority
Get-WmiObject -Class Win32_Process

Get-WmiObject win32_process | Select-Object ParentProcessId,ProcessId

#Process that created the thread
Get-WmiObject -Class Win32_Thread | select handle,ProcessHandle

(Get-WmiObject win32_process) | Select-Object Name,CommandLine | Format-Custom
```

# Ejercicio sobre hilos

## Almacenar información sobre los hilos
```PowerShell
(Get-WmiObject -Class Win32_Thread  | Format-Table -Property priority, thread*, User*Time, kernel*Time ).count | Out-File q:\analisis.txt
Get-Process | select name | Out-File q:\analisis.txt
Start-Sleep -Seconds 5
```

# Ejercicio avanzado

## Almacenar información sobre hilos de forma continuada
```PowerShell
while(1)
{
(Get-WmiObject -Class Win32_Thread  | Format-Table -Property priority, thread*, User*Time, kernel*Time ).count | Out-File q:\analisis.txt -Append
Get-Process | select name | Out-File q:\analisis.txt -Append

Start-Sleep -Seconds 5
"Ejecutado"
}
```

## Mostrar los hilos de cada proceso utilizando WMI y el cmdlet Get-Process
```PowerShell
Get-Process | select name,Threads

(Get-Process -Name notepad) | select Threads | select *

Get-WmiObject -Class Win32_Thread | select Handle,ProcessHandle,priority | sort priority -Descending

(Get-WmiObject -Class Win32_Thread -Filter "ProcessHandle = 1052")

(Get-WmiObject -Class Win32_Thread -Filter "ProcessHandle = $((gps -name notepad).id)") | %{
    $_.Handle, $_.ProcessHandle, (Get-Process -Id $_.ProcessHandle).ProcessName
}
```
