# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Adjunto ejercicio visto en mi equipo sobre compartir memoria
- Utilizar zonas de memoria compartida en Linux mediante WSL desde PowerShell
https://www.jesusninoc.com/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/
- Uso de las funciones ftok(), shmget(), shmat() y shmctl() (ejemplo)
https://www.jesusninoc.com/11/22/uso-de-las-funciones-ftok-shmget-shmat-y-shmctl-ejemplo/
- Uso de las funciones ftok(), shmget(), shmat() y shmctl()
https://www.jesusninoc.com/2014/11/22/uso-de-las-funciones-ftok-shmget-shmat-y-shmctl/

# Ejercicios PowerShell sobre variables

## Mostrar un char desde un int
```PowerShell
[Int]'A'[0]
```
## Mostrar un int desde un char
```PowerShell
[Char]65
```
## Ejecutar un cmdlet leyendo desde un fichero el cmdlet
```PowerShell
"gps" | Out-File ejecutar.txt
Invoke-Expression (gc .\ejecutar.txt)
```
## Modificar el contenido de un fichero
```PowerShell
1 | Out-File ejemplo1.txt
(gc ejemplo1.txt)+"modificado" | Out-File ejemplo2.txt
gc .\ejemplo2.txt
```
## Modificar el contenido de un fichero (leer un número de un fichero y sumar un número, después almacenar el varlor)
```PowerShell
1 | Out-File ejemplo1.txt
[Int](gc ejemplo1.txt)+1 | Out-File ejemplo2.txt
gc .\ejemplo2.txt
```
## Modificar el contenido de un fichero (leer un número de un fichero y restar un número, después almacenar el varlor)
```PowerShell
1 | Out-File ejemplo1.txt
[Int](gc ejemplo1.txt)-1 | Out-File ejemplo2.txt
gc .\ejemplo2.txt
``` 
## Modificar el contenido de un fichero utilizando variables (leer un número de un fichero y restar un número, después almacenar el varlor)
```PowerShell
1 | Out-File ejemplo1.txt
$ejemplo1 = [Int](gc ejemplo1.txt)
$ejemplo1 - 1 | Out-File ejemplo2.txt
gc .\ejemplo2.txt
```
## Listar la mitad de un número de procesos y ordenarlos (el usuario introduce los valores en variables y los almacena en ficheros)
```PowerShell
$first = Read-Host "intro first"
$first | Out-File first.txt

$orden = Read-Host "intro orden"
$orden | Out-File orden.txt
gps | select -First ([Int ]$first / 2) | sort $orden
```

## Guardar un valor aleatorio en un fichero
```PowerShell
(Get-Random (1..5)) | Out-File aleatorio.txt
```
