# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Solución al ejercicio de almacenar en un fichero los procesos que se están ejecutando y la fecha actual:
```PowerShell
Get-Date|Out-File f.txt;Get-Process|Select-Object Name,CPU|Out-File f.txt -Append
date >> f.txt;gps|select Name,CPU >> f.txt
date >> f;ps|select Name,cpu >> f
(date),(ps|select Name,cpu)>>f
```
# Solución avanzada creando alias:
```PowerShell
Set-Alias -Name d -Value date
Set-Alias -Name p -Value ps
Set-Alias -Name s -Value select
d >> f;p|s Name,CPU >> f
(d),(p|s Name,CPU)>>f
```

# Cmdlets básicos en PowerShell
## 1. Introducción a PowerShell (nivel intermedio)
https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/

# Ejercicios sencillos
## Ejercicios básicos sobre procesos
- Listar procesos por propiedades.
- Listar todos los procesos.
- Mostrar los 5 primeros procesos.
- Mostrar los 5 últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Agrupa los procesos y muestras los que sean svchost.
- Ordena el consumo de CPU de forma descendente.
- Abre 5 notepad, ordena por el consumo de CPU.
- Abre 5 notepad, utiliza y ordena por el consumo de CPU.
- Listar las propiedades cpu y PM.
- Obtener información ampliada sobre procesos.
- Obtener los 5 primeros procesos ordenados.
- Listar los procesos que tengan consumo alto de tiempo de CPU.
- Listar los procesos junto el fabricante.
- Mostrar información sobre el proceso notepad.

# R0Ak (The Ring 0 Army Knife) - A Command Line Utility To Read/Write/Execute Ring Zero On For Windows 10 Systems
R0Ak (The Ring 0 Army Knife) - Una utilidad de línea de comandos para leer / escribir / ejecutar Ring Zero On para Windows 10 

r0ak es una utilidad de línea de comandos de Windows que le permite leer, escribir y ejecutar fácilmente código de modo kernel (con algunas limitaciones) desde el símbolo del sistema, sin requerir nada más que privilegios de administrador.
https://www.kitploit.com/2018/09/r0ak-ring-0-army-knife-command-line.html
