# Instalación de software libre y propietario

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.

# WSL
## Windows 10 Installation Guide
https://docs.microsoft.com/en-us/windows/wsl/install-win10
## Check your build number (WSL)
https://docs.microsoft.com/en-us/windows/wsl/troubleshooting#check-your-build-number
## WSL (Windows Subsystem for Linux)
https://github.com/jesusninoc/ClasesISO/blob/cdf3c6ea4c197a5517b0fac5cdf70f381f140842/2018-06-01.md

# Núcleo
## Comandos Kernel
```Bash
uname -r
uname -a
cat /proc/version
dmesg | grep Linux
```

## Comandos versión Windows
```PowerShell
Get-CimInstance Win32_OperatingSystem
[System.Environment]::OSVersion.Version
````

# Cmdlets básicos en PowerShell
## 1. Introducción a PowerShell para administradores de sistemas (nivel básico)
https://www.jesusninoc.com/2016/09/26/1-introduccion-a-powershell-para-administradores-de-sistemas/
## 1. Introducción a PowerShell (nivel intermedio)
https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/

# Ejercicio
## Guardar en un fichero la versión de Windows utilizando un cmdlet
```PowerShell
[System.Environment]::OSVersion.Version | Out-File version.txt
```
## Guardar en un fichero la versión del núcleo de Linux utilizando un cmdlet
```PowerShell
wsl uname -r | Out-File nucleo.txt
```

# R0Ak (The Ring 0 Army Knife) - A Command Line Utility To Read/Write/Execute Ring Zero On For Windows 10 Systems
R0Ak (The Ring 0 Army Knife) - Una utilidad de línea de comandos para leer / escribir / ejecutar Ring Zero On para Windows 10 

r0ak es una utilidad de línea de comandos de Windows que le permite leer, escribir y ejecutar fácilmente código de modo kernel (con algunas limitaciones) desde el símbolo del sistema, sin requerir nada más que privilegios de administrador.
https://www.kitploit.com/2018/09/r0ak-ring-0-army-knife-command-line.html
