# Red

## Relación entre puertos UDP y procesos (construir un objeto con propiedades personalizadas)
https://www.jesusninoc.com/2018/05/02/relacion-entre-puertos-udp-y-procesos-construir-un-objeto-con-propiedades-personalizadas/

## Relación entre puertos TCP y procesos (construir un objeto con propiedades personalizadas)
https://www.jesusninoc.com/2018/05/03/relacion-entre-puertos-tcp-y-procesos-construir-un-objeto-con-propiedades-personalizadas/

## Conectarse a una carpeta compartida con PowerShell
https://www.jesusninoc.com/2017/06/14/conectarse-a-una-carpeta-compartida-con-powershell/

## Instalar remotamente un paquete MSI
https://www.jesusninoc.com/2017/05/27/instalar-remotamente-un-paquete-msi/

## Enabling Remoting
There are many ways how cmdlets can get remote information from another computer. Here are just a few:

```PowerShell
# try and connect to this computer
# (adjust it to a valid name in your network) 
$destinationServer = "SERVER12"
 
# PowerShell remoting 
$result1 = Invoke-Command { Get-Service } -ComputerName $destinationServer
 
# built-in 
$result2 = Get-Service -ComputerName $destinationServer
$result3 = Get-Process -ComputerName $destinationServer
```

If you’d like to open up the most commonly used remoting techniques on a test machine, run these lines from a PowerShell with elevated privileges:

```PowerShell
netsh firewall set service remoteadmin enable 
Enable-PSRemoting -SkipNetworkProfileCheck -Force
```
## Lateral Movement Using WinRM and WMI
https://redcanary.com/blog/lateral-movement-winrm-wmi/

## Get-WmiObject
http://community.idera.com/powershell/powertips/b/tips/posts/wmi-quick-primer-part-2

Here are two example calls that both retrieve information about file shares from a remote system (make sure you adjust the computer name):
```PowerShell
Get-WmiObject -Class Win32_Share -ComputerName sr0710 
Get-CimInstance -ClassName Win32_Share -ComputerName sr0710
```

## Get-CimInstance
While Get-WmiObject always uses DCOM as a transport protocol, Get-CimInstance uses WSMan (a webservice-type of communication). Most modern Windows systems support WSMan, but if you need to contact older servers, they may only respond to DCOM, thus Get-CimInstance may fail.

Get-CimInstance can use session options, however, that provide great flexibility, and allow you to choose the transport protocol. In order to use DCOM (just like Get-WmiObject), do the following:

```PowerShell
$options = New-CimSessionOption -Protocol Dcom 
$session = New-CimSession -ComputerName sr0710 -SessionOption $options
$sh = Get-CimInstance -ClassName Win32_Share -CimSession $session 
Remove-CimSession -CimSession $session
```

Here is an example illustrating how the same session is used for two queries:
http://community.idera.com/powershell/powertips/b/tips/posts/wmi-quick-primer-part-3
```PowerShell
# create the session 
$options = New-CimSessionOption -Protocol Wsman 
$session = New-CimSession -ComputerName sr0710 -SessionOption $options
 
# reuse the session for as many queries as you like 
$sh = Get-CimInstance -ClassName Win32_Share -CimSession $session -Filter 'Name="Admin$"' 
$se = Get-CimInstance -ClassName Win32_Service -CimSession $session
 
# remove the session at the end 
Remove-CimSession -CimSession $session
```

## Packet generator
A packet generator or packet builder is a type of software that generates random packets or allows the user to construct detailed custom packets. Depending on the network medium and operating system, packet generators utilize raw sockets, NDIS function calls, or direct access to the network adapter kernel-mode driver.

|Title|Author|OS|Interface|License|
|---|---|---|---|---|
AnetTest|Anton aka kronos256|Windows, Unix|CLI|GPL
Bit-Twist|Addy Yeow Chin Heng|Windows, Linux, BSD, Mac OS X|CLI|GPLv2
Cat Karat packet builder|Valery Diomin, Yakov Tetruashvili|Windows|GUI|Packet Builder License
Colasoft Packet Builder|Colasoft|Windows|GUI|Packet Builder License: Freeware
CommView Packet Generator |TamoSoft|Windows|GUI|Proprietary EULA
IP Sorcery|Josiah Zayner|Unix|CLI and GUI|GPL
Nemesis|Jeff Nathan|Windows, Unix|CLI|BSD
Ostinato|Srivats P|Windows, Linux, BSD, Mac OS X|GUI and API|GPLv3
Packet Construction Set|George Neville-Neil|Linux, BSD, Mac OS X|CLI|BSD-like
Packet Sender|Dan Nagle|Windows, Linux, Mac OS X|CLI and GUI|GPLv2
Pktgen|Linux Foundation|Linux|CLI|GPLv2
packETH|Miha Jemec aka jemcek|Linux, Windows|GUI|GPLv2
pierf|Pieter Blommaert|Windows(Cygwin)/Linux|CLI|free BSD
rain|Michael Behan|Linux, BSD|CLI|free GPLv2
Scapy|Philippe BIONDI|Linux/Unix/Windows|CLI|GPLv2
targa3|Mixter|Linux, Unix|CLI|?
UMPA|Adriano Monteiro Marques|Cross-platform (Python)|?|GPLv2
trafgen|Daniel Borkmann|Linux|CLI|GPLv2
xcap|cxxxap|Windows|GUI|Free
Simple Packet Sender (SPS)|h0h1r4um|Linux|GUI|GPLv3
WARP17|Juniper Networks|Linux|CLI and API|BSD
Wirefloss|Wirefloss|Web page|GUI|Free

## Modificar paquetes
### Modificar la dirección IP de origen en mensajes UDP con SoftPerfect Network Protocol Analyzer
https://www.jesusninoc.com/2016/04/02/modificar-la-direccion-ip-de-origen-en-mensajes-udp-con-softperfect-network-protocol-analyzer/
### Modificar datagramas UDP con SoftPerfect Network Protocol Analyzer
https://www.jesusninoc.com/2016/03/19/modificar-datagramas-udp-con-softperfect-network-protocol-analyzer/
### Polymorph: Modificando paquetes de red en tiempo real. Inyectando JavaScript en peticiones HTTP
http://www.elladodelmal.com/2018/04/polymorph-modificando-paquetes-de-red.html
http://www.elladodelmal.com/2018/04/polymorph-modificando-paquetes-de-red_30.html
http://www.elladodelmal.com/2018/05/polymorph-modificando-paquetes-de-red.html

## Archivos sin conexión
https://answers.microsoft.com/es-es/windows/forum/windows_10-files/archivos-de-red-sin-conexi%C3%B3n-win10-pro/db125e74-b42a-4fac-948f-4b66bbd00a12

## VPN
### Always On VPN Windows 10 Device Tunnel Step-by-Step Configuration using PowerShell
https://directaccess.richardhicks.com/2017/12/11/always-on-vpn-windows-10-device-tunnel-step-by-step-configuration-using-powershell/

### Dis root
https://disroot.org/en

## Security
### Get things from one computer to another, safely
This package provides a library and a command-line tool named wormhole, which makes it possible to get arbitrary-sized files and directories (or short pieces of text) from one computer to another. The two endpoints are identified by using identical "wormhole codes": in general, the sending machine generates and displays the code, which must then be typed into the receiving machine.
* https://github.com/warner/magic-wormhole
* https://magic-wormhole.readthedocs.io/en/latest/welcome.html#example

### Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/

# Monitorizar

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

## System Monitor
System Monitor (Sysmon) is a Windows system service and device driver that, once installed on a system, remains resident across system reboots to monitor and log system activity to the Windows event log. It provides detailed information about process creations, network connections, and changes to file creation time. By collecting the events it generates using Windows Event Collection or SIEM agents and subsequently analyzing them, you can identify malicious or anomalous activity and understand how intruders and malware operate on your network.

Install with default settings (process images hashed with sha1 and no network monitoring)
```MD-DOS
sysmon -accepteula –i
```
Install with md5 and sha256 hashing of process created and monitoring network connections
```MD-DOS
sysmon -accepteula –i –h md5,sha256 –n
```
Install Sysmon with a configuration file (as described below)
```MD-DOS
sysmon –accepteula –i c:\windows\config.xml
```
Uninstall
```MD-DOS
sysmon –u
```
Dump the current configuration
```MD-DOS
sysmon –c
```
Change the configuration to use all hashes, no network monitoring and monitoring of DLLs in Lsass
```MD-DOS
sysmon –c –h * –l lsass.exe
```
Change the configuration of sysmon with a configuration file (as described below)
```MD-DOS
sysmon –c c:\windows\config.xml
```
Change the configuration to default settings
```MD-DOS
sysmon –c --
```
Show the configuration schema
```MD-DOS
sysmon -s
```

## Sources, configuration and how to detect evil things utilizing Microsoft Sysmon
https://github.com/MHaggis/sysmon-dfir

# Logs en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

## List event log
https://www.jesusninoc.com/2018/03/27/list-event-log/hell

## Write-EventLog
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/write-eventlog?view=powershell-5.1

## Escribir y ver un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/04/escribir-y-ver-un-evento-en-el-registro-de-eventos-de-aplicacion/

## Almacenar información convertida a byte en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/05/almacenar-informacion-convertida-a-byte-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

## Ejecutar la información que se encuentra en un evento en el registro de eventos de aplicación
https://www.jesusninoc.com/2018/05/06/ejecutar-la-informacion-que-se-encuentra-en-un-evento-en-el-registro-de-eventos-de-aplicacion/

## Windows Event Log to the Dark Side — Storing Payloads and Configurations
https://medium.com/@5yx/windows-event-log-to-the-dark-side-storing-payloads-and-configurations-9c8ad92637f2

## Active Directory: Configuring Event Log Subscriptions (Forwarding)
https://sid-500.com/2018/04/23/active-directory-configuring-event-log-subscriptions-forwarding/

# Logs en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-13.md#registros-de-sucesos

```Bash
cd /var/log
ls
```

- /var/log/message: registro de mensajes generales del sistema
- /var/log/auth.log: log de autenticación
- /var/log/kern.log: registro del kernel
- /var/log/cron.log: registro de crond
- /var/log/maillog: registro del servidor de mails
- /var/log/qmail/ : registro de Qmail
- /var/log/httpd/: registro de errores y accesos a Apache
- /var/log/lighttpd: registro de errores y accesos a Lighttpd
- /var/log/boot.log : registro de inicio del sistema
- /var/log/mysqld.log: registro de la base de datos MySQL
- /var/log/secure: log de autenticación
- /var/log/utmp or /var/log/wtmp : registro de logins

## Analizar logs en Linux
### Regular Expressions
```Bash
 grep "user juanito" /var/log/auth.log
```
### Tail
```Bash
$ tail -f /var/log/auth.log | grep 'invalid'
```
### Cut
```Bash
grep "authentication failure" /var/log/auth.log | cut -d '=' -f 8
```
### Awk
```Bash
awk '/sshd.*invalid user/ { print $9 }' /var/log/auth.log
```
