# Demos Navigate around the edge with PowerShell (Jaap Brasser)
https://github.com/jesusninoc/2018/tree/master/Jaap%20Brasser/Navigate%20around%20the%20edge%20with%20PowerShell
https://github.com/jesusninoc/2018/blob/master/Jaap%20Brasser/Navigate%20around%20the%20edge%20with%20PowerShell/Navigate%20around%20the%20edge%20with%20PowerShell.zip

```PowerShell
# Credential object
$Cred = Get-Credential -Credential psconfeu\dictator
$Cred | Export-Clixml -Path C:\Temp\Dictator_Cred.xml
$Cred = Import-CliXml -Path C:\Temp\Dictator_Cred.xml

# Display credential object
$Cred

# PowerShell Remoting
Enter-Pssession -ComputerName 127.0.0.1 -Credential $Cred
Get-ComputerInfo
Exit-PSSession

$Session = New-PSSession -ComputerName 127.0.0.1 -Credential $Cred
Invoke-Command -Session $Session {
    Get-ComputerInfo
}

$CmdOutput = Invoke-Command -Session $Session {
    Get-ComputerInfo
}

$CmdOutput.GetType()

Invoke-Command -Session $Session {
    Get-HotFix | Format-Table -AutoSize
}
```
