# Examen intermedio de tercera evaluación

https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-19.md

# Preguntas examen intermedio 2018

## Tener en cuenta:
- Tener varias máquinas con varias IP's
- Se pueden utilizar varios nombres de equipos (hosts)
- Compartir carpetas en Linux
- Acceder a las carpetas en Linux desde Windows

## 1. Analizar ficheros DLL en todos los equipos de la red
```PowerShell
123..125 | %{"192.168.104." + $_}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
$ruta
}

123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.jes"
ls $ruta
}

39..40 | %{Invoke-Command -ComputerName ("192.168.104." + $_) -ScriptBlock {ls} }
```
### Enable and Use Remote Commands in Windows PowerShell
https://technet.microsoft.com/en-us/library/ff700227.aspx
### How to Add a Computer to the TrustedHosts List
```PowerShell
set-item wsman:\localhost\Client\TrustedHosts -value "ABANTO"
```

## 2. Analizar ficheros DLL en todos los equipos de la red, comprobar que ha cambiado una integridad y copiar el fichero que ha cambiado
### En PowerShell
```PowerShell
mkdir dlls

cd dlls

"dll1" | Out-File dll1.dll
"dll2" | Out-File dll2.dll

# Recorrrer una a una dll
ls *.dll | %{$_}

# Hacer hash de cada dll
ls *.dll | %{Get-FileHash $_.FullName | Select-Object Hash}

# Hacer hash de cada dll ruta por red
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path}

# Guardar hash
ls '\\localhost\c$\Users\juan\dlls' *.dll | %{Get-FileHash $_.FullName | Select-Object Hash,Path | Out-File listado.txt -Append}

# Ver listado
gc .\listado.txt

# Modificar dll y detectar el cambio, después mover la dll, solución: el hash de cada dll no se encuentra en el fichero listado.txt, eso quiere decir que se ha modificado y hay que copiar a la carpeta compartida en Linux
# Modificar dll
"dll6" | Out-File dll1.dll

ls '\\localhost\c$\Users\juan\dlls' *.dll | %{
    if((gc .\listado.txt) -match (Get-FileHash $_.FullName | Select-Object Hash).hash)
    {
    }
    else
    {
        $_.Name
        "Dll se ha modificado"
    }
}


# Meter el código anterior en el recorrido que cada alumno tenga
123..125 | %{
$ruta="\\192.168.104." + $_ +"\c$\*.dll"
ls $ruta -recurse
}
```
### En Linux
https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

## 3. Puedes saber qué fichero DLL están funcionando en el equipo utilizando la red
(Get-Process -ComputerName .).Modules

## 4. Detectar que una aplicación tiene tráfico de red (filtro por puerto)
### Tshark Command Examples
https://linuxsimba.com/tshark-examples

```PowerShell
$filterUDP = ''
$filterTCP = ''
ps | where ProcessName -eq 'chrome' | %{
    Get-NetUDPEndpoint | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterUDP = $filterUDP+'(udp.port == '+$_.LocalPort+') or'
    }
    
    Get-NetTCPConnection | where OwningProcess -EQ $_.Id | select LocalPort | % {
        $filterTCP = $filterTCP+'(tcp.port == '+$_.LocalPort+') or'
    }
    
    
}
$filterUDP = $filterUDP.substring(0, $filterUDP.Length-3)
$filterTCP = $filterTCP.substring(0, $filterTCP.Length-3)

$filter = $filterUDP+' or '+$filterTCP

net use \\192.168.104.129\Prueba-share-samba /user:root 1234

.\tshark.exe -i 'ethernet 2' -Y $filter > \\192.168.104.129\Prueba-share-samba\test.txt
```
