# Arranque
- BIOS
- POST
- Arranque (dual, BCD, BCDEdit, etc.)
- Arranque de procesos

## Arranque en Linux
### Proceso de arranque en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-01-23.md

## Arranque en Windows
### Proteger el proceso de arranque de Windows 10
https://docs.microsoft.com/es-es/windows/security/hardware-protection/secure-the-windows-10-boot-process
### Procesos de credenciales de autenticación de Windows
https://docs.microsoft.com/es-es/windows-server/security/windows-authentication/credentials-processes-in-windows-authentication

# Compartir carpetas en Linux
## Access the Windows Share from Linux
https://www.howtogeek.com/176471/how-to-share-files-between-windows-and-linux/

```Bash
sudo apt-get install cifs-utils
mkdir ~/Desktop/Windows-Share 
sudo mount.cifs //WindowsPC/Share /home/jes/Desktop/Windows-Share -o user=jesusninoc
````

## Create a Share on Linux and Access It from Windows
```Bash
sudo apt-get install samba
smbpasswd -a jesusninoc
mkdir ~/Desktop/Share
sudo vi /etc/samba/smb.conf

[<folder_name>]
path = /home/<user_name>/<folder_name> 
available = yes 
valid users = <user_name> 
read only = no 
browsable = yes 
public = yes 
writable = yes

sudo service smbd restart
```

# Resumen de comandos para examen liberatorio (Linux)
https://github.com/jesusninoc/Bash/blob/master/Repaso/ResumenComandosExamenLiberatorio

# Repaso scripting (extraer caracteres de cadenas)
```Bash
short=$(echo "${long}" | cut -c1-2)
short=$(echo "${long}" | head -c2)
short=$(echo "${long}" | awk '{print substr ($0, 0, 2)}'
short=$(echo "${long}" | sed 's/^\(..\).*/\1/')
```

# Ficheros de configuración en Linux

## Network
http://www.yolinux.com/TUTORIALS/LinuxTutorialNetworking.html

### File: /etc/network/interfaces
```Bash
auto lo
iface lo inet loopback

auto eth0
iface eth0 inet static
        address 208.88.34.106
        netmask 255.255.255.248
        broadcast 208.88.34.111
        network 208.88.34.104
        gateway 208.88.34.110
```

## login.defs - shadow password suite configuration
http://man7.org/linux/man-pages/man5/login.defs.5.html

# RAID en Linux

```Bash
mdadm -Cv /dev/md0 -l0 -n2 -c128 /dev/sdb1 /dev/sdc1
```
