# Ejercicios sobre redes
- Detectar en red dispositivos
```PowerShell
(Get-NetNeighbor | Where-Object {$_.IPAddress -match "192.168"}).IPAddress
```
- Conexión entre alumnos para detectar dispositivos
- Conectarse utilizando protocolos de capa Aplicacion (SSH)
- Comprobar integridad de ficheros en carpetas remotas
- Carpetas compartidas con permisos

https://www.jesusninoc.com/2015/08/19/anadir-permiso-ntfs-a-una-carpeta/
- Conexión con sockets en Linux

https://github.com/jesusninoc/ClasesSeguridad/blob/master/2018-02-21.md
- Conexión con sockets en PowerShell

https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
- Analizar el tráfico por red:

https://hackertarget.com/tshark-tutorial-and-filter-examples/
```MS-DOS
tshark -R "ip.addr == 192.168.0.1" -w f:\power\capture.cap
```
- Tcpdump Examples

https://hackertarget.com/tcpdump-examples/

- ¿Qué estoy imprimiendo?
- Crear un iventario de lo que tiene un equipo (conectar a varios equipos) y guardar la información en una carpeta compartida
```PowerShell
#Llamadas WMI
$ComputerSystem=Get-WmiObject Win32_ComputerSystem
$BaseBoard=Get-WmiObject Win32_BaseBoard
$BIOS=Get-WmiObject Win32_BIOS
$Processor=Get-WmiObject Win32_Processor
$Battery=Get-WmiObject Win32_Battery
 
#Crear un objeto con todos los datos sobre el hardware
[PSCustomObject]@{
 Model = $ComputerSystem.Model
 ManufacturerBoard = $BaseBoard.Manufacturer
 BIOSVersion = $BIOS.SMbiosbiosversion
 BIOSSerialNumber = $BIOS.serialnumber
 ManufacturerProcessor=$Processor.Manufacturer
 MaxClockSpeed=$Processor.MaxClockSpeed
 DeviceIDBattery=$Battery.DeviceID.trim()
}
```
- Analizar las conexiones abiertas en un equipo
- Fuerza bruta

https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-17.md#simular-una-fuerza-bruta-mediante-peticiones-http-desde-powershell-utilizando-el-m%C3%A9todo-get
- Analizar conexiones de red analizando el tráfico de red y relacionarlo con hilos, procesos y servicios
```PowerShell
cd "C:\Program Files\Wireshark\"
tshark -r capture.pcap -Y "udp or tcp"
gc .\todo.txt |%{ $_}
```
```PowerShell
Get-NetTCPConnection | Where-Object {$_.RemotePort -eq $_.split(" ")[5]}
```
```PowerShell
Get-NetTCPConnection | select OwningProcess | %{Get-Process -id $_.OwningProcess}
```
```PowerShell
netstat -ano
```
- Mostrar los hilos que se están ejecutando en relación con los servicios y los procesos

https://www.jesusninoc.com/2015/10/28/mostrar-los-hilos-que-se-estan-ejecutando-en-relacion-con-los-servicios-y-los-procesos/

- Mostrar los hilos que se están ejecutando en relación con los servicios, los procesos y los puertos abiertos TCP

https://www.jesusninoc.com/2017/04/04/mostrar-los-hilos-que-se-estan-ejecutando-en-relacion-con-los-servicios-los-procesos-y-los-puertos-abiertos-tcp/

- Mostrar los hilos que se están ejecutando en relación con los servicios, los procesos y los puertos abiertos UDP

https://www.jesusninoc.com/2017/03/11/mostrar-los-hilos-que-se-estan-ejecutando-en-relacion-con-los-servicios-los-procesos-y-los-puertos-abiertos-udp/

- Buscar direcciones IP en la red local y realizar una consulta DNS
```PowerShell
(Get-NetNeighbor).IPAddress | Select-String "192.168.1." | % {
Resolve-DnsName $_
}
```

- Resolver la siguiente situación

https://github.com/jesusninoc/ClasesSeguridad/blob/master/2018-02-14.md

- Analizar DLL en un equipo remoto
