# Permisos en PowerShell

## 4. Gestión de archivos en PowerShell para administradores de sistemas
https://www.jesusninoc.com/2016/11/10/4-gestion-de-archivos-en-powershell-para-administradores-de-sistemas/

## Obtener los descriptores de seguridad de todos los ficheros de una unidad
https://www.jesusninoc.com/2016/09/10/obtener-los-descriptores-de-seguridad-de-todos-los-ficheros-de-una-unidad/

## Enumeración FileSystemRights: Define los derechos de acceso que se utilizará al crear reglas de acceso y auditoría
https://msdn.microsoft.com/es-es/library/system.security.accesscontrol.filesystemrights(v=vs.110).aspx

## Clonar permisos NTFS
https://www.jesusninoc.com/2015/01/23/clonar-permisos-ntfs/

## Eliminar permisos explícitos
https://www.jesusninoc.com/2016/03/30/eliminar-permisos-explicitos/

## Añadir permiso NTFS a una carpeta
https://www.jesusninoc.com/2015/08/19/anadir-permiso-ntfs-a-una-carpeta/

## Weekend Scripter: Use PowerShell to Get, Add, and Remove NTFS Permissions
https://blogs.technet.microsoft.com/heyscriptingguy/2014/11/22/weekend-scripter-use-powershell-to-get-add-and-remove-ntfs-permissions/

## Ejemplo de asignación de permisos
```PowerShell
New-Item -type directory -path C:\MyFolder
$Acl = Get-Acl "C:\MyFolder"
$Ar = New-Object  system.security.accesscontrol.filesystemaccessrule("username","FullControl","Allow")
$Acl.SetAccessRule($Ar)
Set-Acl "C:\MyFolder" $Acl
```

# Permisos en Linux
Why does the default umask value contains 4 digits?
The first digit in 0022 defines the special permission value. In case you want to set any special permission to every file/directory to be created then you can define the value accordingly.

For understanding all the special permission and their value follow the below link
- Understanding Special Permission SGID in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-sgid.html
- Understanding Special Permission SUID in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-suid.html
- Understanding Special Permission Sticky Bit in Linux
http://www.golinuxhub.com/2013/03/understanding-special-permission-sticky.html

## Comando para ver permisos de un fichero
```Bash
stat -f "%Sp -> owner=%SHp group=%SMp other=%SLp" fichero.txt  
```

## Ejemplo sobre asignación de permisos al crear carpetas
### Creates a new directory called mydir whose parent is the current directory.
```Bash
mkdir examples
mkdir mydir
```
Create the mydir directory, and set its permissions such that all users may read, write, and execute the contents.
```Bash
mkdir -m a=rwx mydir
```
Creates the directory /home/chope/a/b/c. If the parent directory /home/chope/a/b does not already exist, mkdir will create that directory first.
```Bash
mkdir -p /home/chope/a/b/c
```

# Permisos avanzados en C
http://www.jesusninoc.com/2015/01/19/programacion-de-permisos/

# Contraseñas

## Contraseñas seguras con PowerShell
https://www.jesusninoc.com/contrasenas-seguras-con-powershell/

# Contraseñas y fuerza bruta

## Realizar petición HTTP desde PowerShell utilizando el método GET
https://www.jesusninoc.com/2018/03/31/realizar-peticion-http-desde-powershell-utilizando-el-metodo-get/

## Simular una fuerza bruta mediante peticiones HTTP desde PowerShell utilizando el método GET
https://www.jesusninoc.com/2018/04/01/simular-una-fuerza-bruta-mediante-peticiones-http-desde-powershell-utilizando-el-metodo-get/

## crunch
Crunch is a wordlist generator where you can specify a standard character set or a character set you specify. crunch can generate all possible combinations and permutations.
https://tools.kali.org/password-attacks/crunch

## CeWL
CeWL is a ruby app which spiders a given url to a specified depth, optionally following external links, and returns a list of words which can then be used for password crackers such as John the Ripper.
https://tools.kali.org/password-attacks/cewl

## HUNT: Data Driven Web Hacking & Manual Testing - JP Villanueva - AppSecUSA 2017
https://www.youtube.com/watch?v=IEak_-SG8xM

## Using Hydra To Crack The Door Open
https://hakin9.org/usinghydratocrackthedooropen/

```MS-DOS
hydra <ip>-s <puerto> http-form-post "/:user=^USER^&password=^PASS^:<Mensaje de error>" -l "" -P <diccionario> -t 10 -v -I -o <archivo de salida>
hydra IP http-form-post "/index.php:user=^USER^&pass=^PASS^:error_msg" -l admin -P dicc.txt
```
Ese ejemplo es suponiendo que:
- Hay un parametro user que quieres que sea "admin"
- Hay un parametro pass que lo va a ir probando de dicc.txt
- Cuando metes mal un login aparece entre otras cosas el texto "error_msg"
