# Cmdlets for TCP/IP Model Layers
https://www.jesusninoc.com/2015/11/13/cmdlets-for-tcpip-model-layers/

- Aplicación	DNS, DHCP, RIP, ...
- Transporte	TCP, UDP, ...
- Red	IP, ...
- Enlace	Ethernet, Token Ring,
- FDDI, ...

## Capa 1
- Conocer los interfaces físicos
```PowerShell
Get-Command -Module Net* | Group Module
Get-NetAdapter -Physical | Select-Object 
Get-NetIPAddress | Select-Object InterfaceAlias,IPAddress
```
- Bytes recibidos y transmitidos
```PowerShell
Get-NetAdapterStatistics
```
## Capa 2
### Arp
- MacAddress
- Conocer la MAC
- Entradas ARP
- Todas las formas de ver la MAC, por comandos
```PowerShell
arp -a | Select-String "((?:(\d{1,2}|[a-fA-F]{1,2}){2})(?::|-*)){6}" | Select-String "192.168"
```
```PowerShell
Get-NetNeighbor
Get-NetNeighbor | Select-Object IPAddress | Select-String "192.168"
```
### Switch
- ¿Estoy cerca de un switch?
- Visitar página con relación de MAC y fabricantes
- OUI: https://www.wireshark.org/tools/oui-lookup.html
- Identificar MAC con fabricante
- Intentar localizar el mayor número de nodos de red y dispositivos de acceso, tener en cuenta subred
- Tabla de direccionamiento switch?????
- Ver las direcciones MAC de difusión FFFFF y otros tipos quiénes son los vecinos
https://en.wikipedia.org/wiki/Multicast_address
- macs broadcast y demás
- Saltos switches, cuántos hay? utilizar tracert
- mac broadcast qué hace y donde va
- MITM

## Capa 3
- Conocer IP virtual y física
- ¿Ves alguna relación?
- Tipo red colegio privada y publica
- red apipa
- Relación entre rutas y los índices de tarjetas
```PowerShell
Get-NetRoute
```
- Rangos de ips y análisis de whois y demás
- Analizar las IP de la red
- Relación con ARP
- Mac relación netstat y arp -a
- Buscar IP en el registro
- Ping a subredes
```PowerShell
foreach($tercero in 1..254)
{
    foreach($cuarto in 1..254)
    {
        ping '192.168.'+$tercero+'.'+$cuarto
    }
}
```
https://www.jesusninoc.com/2017/07/14/recorrer-un-rango-de-direcciones-ip/
https://www.jesusninoc.com/2017/07/06/recorrer-direcciones-ip/
https://github.com/jesusninoc/PowerShell/blob/master/Red/EjemplosRed.ps1
### ICMP
- Qué es el ping (Internet)
- Hacer ping a direcciones de red
- Comprobar funcionamiento de comando: ping y tracert
```PowerShell
Test-NetConnection
```
- ip de google ping -a
- ip detectar servicio como Dropbox
### NAT
- explicar nat y pat
### Firewall
- bloquear ip firewall windows
http://www.itechlounge.net/2014/11/windows-blocking-ip-from-command-line/
- log del firewall

## Capa 4
- Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/
- IANA Y UDP 
http://www.jesusninoc.com/2016/03/02/relacion-entre-puertos-abiertos-udp-y-lista-de-puertos-de-la-iana/
- COMUNICACIÓN TCP UDP
- SOCKET, BIND, LISENT, ACCEPT, CONNECT, SEND, RECEIVE, CLOSE
- ABRIR UN PUERTO?
```PowerShell
netsh advfirewall firewall add rule name="Programa TCP 87" dir=in action=allow protocol=TCP localport=87
```
- Lista de puertos IANA
http://www.jesusninoc.com/2016/02/29/relacion-entre-puertos-abiertos-tcp-y-lista-de-puertos-de-la-iana/
- YA EN CAPA 4, DETECTAR PUERTOS Y DEMÁS....... TENGO MIS SCRIPTS LEYENDO DE RFC PUERTOS
- ¿CUÁL ES MI IP PÚBLICA?
http://www.jesusninoc.com/2015/02/28/cual-es-mi-ip-publica/
- reserva v4
https://isc.sans.edu/forums/diary/Reserved+IP+Address+Space+Reminder/13228
### TCP (Transmission Control Protocol)
- Settings
```PowerShell
Get-NetTCPSetting
```
- Gets information about current connection statistics
```PowerShell
Get-NetTCPConnection
```
- Ports
```PowerShell
Get-NetTCPConnection | Select-Object LocalPort,Remoteport
```
### UDP (User Datagram Protocol)
- Settings
```PowerShell
Get-NetUDPSetting
```
- Gets information about current connection statistics
```PowerShell
Get-NetUDPEndpoint
```
- Ports
```PowerShell
(Get-NetUDPEndpoint).LocalPort
```

## Capa 5,6,7
https://en.wikipedia.org/wiki/Category:Application_layer_protocols
