# Repaso semana pasada
##  ISO, WIM
https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-06.md
## Copias de seguridad
https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-06.md
## USB
https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-06.md

## The Win32_Share class represents a shared resource on a computer system running Windows
```PowerShell
gwmi Win32_Share
```
```PowerShell
get-WmiObject -class Win32_Share -computer dc1 -Credential dominio\administrador
```
## Network resources
```PowerShell
net view \\dc1
```

# Repaso básico de Linux para la parte de scripting
* http://www.freeos.com/guides/lsst/ch02.html
* http://www.freeos.com/guides/lsst/ch02sec20.html

# Repaso básico de Windows para la parte de scripting
## Snippets in Windows PowerShell
https://www.jesusninoc.com/2014/03/19/snippets-in-windows-powershell/

# Repaso de examen sobre integridad
## PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosProcesosAvanzado.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Ficheros/EjemploIntegridad.ps1
## Linux
* https://www.jesusninoc.com/2016/01/02/for-loop-examples/
* https://www.jesusninoc.com/2015/07/14/sentencia-condicional-if-else-2/
* https://github.com/jesusninoc/Bash/blob/master/Ficheros/EjemploIntegridad.sh

# Repaso básico de red
## Configurar IP en Windows
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1

## Configurar IP en Linux
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
https://www.tecmint.com/ifconfig-command-examples/

## Conectar con Linux por SSH
https://www.jesusninoc.com/2017/09/26/ejecutar-un-script-de-powershell-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/

## Guardar un fichero html preguntando al usuario qué título quiere
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html
start chrome .\web.html

## Crear y ejecutar un script de Bash realizando una conexión SSH desde PowerShell en Windows
https://www.jesusninoc.com/2017/09/22/crear-y-ejecutar-un-script-de-bash-realizando-una-conexion-ssh-desde-powershell-en-windows/

## Crear y ejecutar un script de Bash realizando una conexión SSH a un contenedor Docker desde PowerShell en Windows
https://www.jesusninoc.com/2017/10/21/crear-y-ejecutar-un-script-de-bash-realizando-una-conexion-ssh-a-un-contenedor-docker-desde-powershell-en-windows/

# Nuevo tema de red

## Análisis de conexiones de red
https://www.jesusninoc.com/2017/05/01/analisis-de-conexiones-de-red/

## Equivalencias entre comandos de red de Windows y cmdlets de PowerShell
https://www.jesusninoc.com/2016/02/04/equivalencias-entre-comandos-de-red-de-windows-y-cmdlets-de-powershell/

## Cmdlets for TCP/IP Model Layers
https://www.jesusninoc.com/2015/11/13/cmdlets-for-tcpip-model-layers/

## Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

## Ejemplos de redes básicos

```PowerShell
1..254|%{$_}
1..254|%{"192.168.1."+$_}
1..254|%{$ip="192.168.1."+$_;$ip}
1..254|%{$ip="192.168.1."+$_;ping $ip}
1..254|%{$ip="192.168.1."+$_;ping $ip;arp -a $ip}
1..254|%{$ip="192.168.1."+$_;$ip;arp -a | Select-String $ip}
```
```PowerShell
Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress
```
```PowerShell
[String]$a=(Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress)
$a.Substring(3,3)
```

## Ejercicio sobre la red

Analizar la siguiente información utilizando la red:
- Aplicaciones instaladas
- Ver si hay IP repetida
- Comprobar si hay fallo en red por culpa de IP repetida
- Comprobar que los equipos se han creado correctamente con el nombre de dominio correcto
- Ver rango de IP en Wifi
- Ver rango de IP en VDI
- ¿Qué usuario ha iniciado sesión?
- Realizar un inventario de la red (PDQ Inventory Tracks It All https://www.pdq.com/pdq-inventory/)

```PowerShell
Invoke-Command -ScriptBlock{([System.Security.Principal.WindowsIdentity]::GetCurrent()).name} -ComputerName 192.168.1.56 -Credential (Get-Credential)
```
```PowerShell
$p = Get-WmiObject win32_process -filter "name='explorer.exe'" -ComputerName 192.168.1.56 -Credential (Get-Credential)
$p.getowner().user
```
